/***************************************************************************
                          bgradoc.cpp  -  description
                             -------------------
    begin                : Thu Feb 10 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for QT

// include files for KDE

// application specific includes

#include "bgradoc.h"
#include <qsize.h>
#include <qcolor.h>

#include "resource.h"

#define STRSEP "\t"

BGraBuff::BGraBuff() {
 	
	setGeometry(0, 0, 800, 600);
	pixmap = new QPixmap(1000, 1000);
  pixmap->fill();
  paint = new QPainter(pixmap);
  paint->setWindow(0, 0,1000,1000);

 	bild_ok = false; 		// Pixmap fr Ausgabe bereit

}

BGraBuff::~BGraBuff(){
}


void BGraBuff::addGraLine(QString zeile){

  bool ok=false;
	int  x1,x2,y1,y2,kz,f,p;
  int pen = 0;
	QString t,tx;

	p=zeile.find(STRSEP);
  t=zeile.left(p);
  zeile.remove(0,p+1);
  kz=t.toInt(&ok);
  p=zeile.find(STRSEP);
  t=zeile.left(p);
  zeile.remove(0,p+1);
  f=t.toInt(&ok);
  if(kz<5){
		p=zeile.find(STRSEP);
    t=zeile.left(p);
    zeile.remove(0,p+1);
    x1=t.toInt(&ok);
    p=zeile.find(STRSEP);
    t=zeile.left(p);
    zeile.remove(0,p+1);
    y1=t.toInt(&ok);
    if(kz==1){
    	p=zeile.find(STRSEP);
     	tx=zeile.left(p);
    }
    if(kz>2){
    	p=zeile.find(STRSEP);
     	t=zeile.left(p);
     	zeile.remove(0,p+1);
     	x2=t.toInt(&ok);
     	p=zeile.find(STRSEP);
     	t=zeile.left(p);
     	zeile.remove(0,p+1);
     	y2=t.toInt(&ok);
    }
	}
//cout<<kz<<"->"<<f<<"/"<<pen<<":"<<x1<<";"<<y1<<"/"<<x2<<";"<<y2<<endl;
  if(pen!=f){
  	pen=f;
    switch(f){
    	case 0:
				 paint->setPen(white);
      	 break;
     	case 1:
				 paint->setPen(black);
         break;
     	case 2:
				 paint->setPen(gray);
         break;
     	case 3:
				 paint->setPen(red);
         break;
     	case 4:
				 paint->setPen(green);
         break;
     	case 5:
				 paint->setPen(blue);
      	 break;
     	case 6:
				 paint->setPen(yellow);
         break;
     	case 7:
				 paint->setPen(cyan);
         break;
     	case 8:
				 paint->setPen(magenta);
         break;
    }
  }

  switch(kz){
  	case 1:
			 paint->drawText(x1,y1+50,tx,tx.length());
       break;
    case 2:
			 paint->drawPoint(x1,y1+50);
       break;
    case 3:
			 paint->drawLine(x1,y1+50,x2,y2+50);
       break;
    case 4:
			 if(x1>x2){
					int z=x1;
          x1=x2;
          x2=z;
       }
       if(x1==x2) paint->drawLine(x1,y1+50,x1,y2+50);
       	else for(int x=x1+1;x<x2;x++) paint->drawLine(x,y1+50,x,y2+50);
       break;
    	case 5:
				switch(f){
        	case 0:
						 paint->setBackgroundColor(white);
             break;
          case 1:
						 paint->setBackgroundColor(black);
             break;
          case 2:
						 paint->setBackgroundColor(gray);
             break;
          case 3:
						 paint->setBackgroundColor(red);
             break;
					case 4:
						 paint->setBackgroundColor(green);
             break;
					case 5:
						 paint->setBackgroundColor(blue);
             break;
          case 6:
						 paint->setBackgroundColor(yellow);
             break;
          case 7:
						 paint->setBackgroundColor(cyan);
             break;
          case 8:
						 paint->setBackgroundColor(magenta);
             break;
        }
        break;
   }

}


void BGraBuff::setBildOk() {
		delete paint;
		bild_ok = true;
}


void BGraBuff::paintEvent(QPaintEvent *e) {

//	QRect r = e->rect();   			//aktuelle Widnowgrsse
  if (bild_ok) bitBlt(this, 0, 0, pixmap); //p, e->rect());
} 								

//void BGraBuff::resizeEvent(QResizeEvent *e){
//	sview->setGeometry(0, 0, width(), height());
//}

BGrafik::BGrafik(QWidget *parent){

  sview = new QScrollView(this);
	bild = new BGraBuff();

	sview->addChild(bild);

	setBackgroundMode(NoBackground);
}

BGrafik::~BGrafik(){
}


void BGrafik::resizeEvent(QResizeEvent *e){
	sview->setGeometry(0, 0, width(), height());
}

void BGrafik::addGraLine(QString s){
	bild->addGraLine(s);
}

void BGrafik::setBildOk(){
	bild->setBildOk();
}













