#ifndef QWT_SPLINE_H
#define QWT_SPLINE_H

class QwtSpline
{
private:

    // coefficient vectors
    double *d_a;
    double *d_b;
    double *d_c;
    double *d_d;

    // values
    double *d_x;
    double *d_y;
    double *d_xbuffer;
    double *d_ybuffer;
    int d_size;

    //flags
    int d_buffered;

    // private member functions
    int lookup(double x);
    void cleanup();
    
 public:

    // constructors
    QwtSpline();
    ~QwtSpline();

    // public members
    double value(double x);
    int recalc(double *x, double *y, int n, int periodic = 0);
    void copyValues(int tf = 1);

 private:

    int buildPerSpline();
    int buildNatSpline();
    
};





#endif





