#ifndef QWT_KNOB_H
#define QWT_KNOB_H
#include <qwt_sldbase.h>
#include <qwt_sclif.h>
#include <qcolor.h>

class QwtKnob : public QwtSliderBase, public QwtScaleIf
{
Q_OBJECT
     
 public:
    enum Symbol { Line, Dot };
	
private:

    int d_borderWidth;
    int d_borderDist;
    int d_hasScale;
    int d_scaleDist;
    int d_maxScaleTicks;
    int d_newVal;
    int d_knobWidth;
    int d_dotWidth;

    Symbol d_symbol;
    double d_angle;
    double d_oldAngle; 
    double d_totalAngle;
    double d_nTurns;
   
    QRect d_kRect;
    QColor d_faceColor;
    QColor d_markerColor;

    void recalcAngle();
	
public:

    QwtKnob(QWidget* parent = 0, const char *name = 0);
    ~QwtKnob();

    void setKnobWidth(int w);
    void setTotalAngle (double angle);
    void setBorderWidth(int bw);
	
private:
	
    void valueChange();
    void rangeChange();
	
    void drawKnob(QPainter *p, const QRect &r);
    void drawMarker(QPainter *p, double arc, const QColor &c);

    void paintEvent(QPaintEvent *e);
    void resizeEvent(QResizeEvent *e);
    double getValue(const QPoint &p);
    void getScrollMode( const QPoint &p, int &scrollMode, int &direction );
    void scaleChange();
    void fontChange();

};


#endif



