/**************************************************************************
 * $Id: SeriesOptions.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SeriesOptions_included
#define SeriesOptions_included

#include <dlg/SeriesOptionsData.h>
#include <SamplinPlotData.h>

class SeriesOptions : public SeriesOptionsData
{
    Q_OBJECT

public:

    SeriesOptions
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~SeriesOptions();
   void setData(SamplinCurve *crv);
   void loadBack(void);
   void loadOld(void); 
   
 protected:
   QString d_name,d_legend;
   int d_xaxis,d_yaxis,d_style,d_pwidth,d_pstyle,d_sptype,d_spsize;
   int d_ssize,d_sstyle,d_swidth;
   QColor d_color,d_scolor,d_sfcolor;
   SamplinCurve *curve;
   

   
// protected slots:
//   virtual void apply();
//   virtual void ok();
//   virtual void cancel();
   
// signals:
//   void update();
   
};
#endif // SeriesOptions_included
