/**************************************************************************
 * $Id: GraphGrid.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "GraphGrid.h"
#include <stdlib.h>

#include "GraphGrid.moc"

#define Inherited GraphGridData

GraphGrid::GraphGrid
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Graph options" );
}


GraphGrid::~GraphGrid()
{
}

void GraphGrid::setData(SamplinPlot *data)
{
   QString s;
   int i;
   
   series=data;
   if(series!=NULL){
      d_xgrid=data->gridXAxis();
      d_ygrid=data->gridYAxis();
      d_majx=data->gridXEnabled();
      d_majy=data->gridYEnabled();
      d_minx=data->gridXMinEnabled();
      d_miny=data->gridYMinEnabled();
      d_majpen=data->gridMajPen();
      d_minpen=data->gridMinPen();
      for(i=0;i<axisCnt;++i)
	d_axisenable[i]=data->axisEnabled(i);
	 
      inp_majx->setChecked(d_majx);
      inp_majy->setChecked(d_majy);
      inp_minx->setChecked(d_minx);
      inp_miny->setChecked(d_miny);
      
      inp_majstyle->setCurrentItem(d_majpen.style());
      s.sprintf("%i",d_majpen.width());
      inp_majwidth->setText(s);
      inp_majcolor->setColor(d_majpen.color());
      inp_minstyle->setCurrentItem(d_minpen.style());
      s.sprintf("%i",d_minpen.width());
      inp_minwidth->setText(s);
      inp_mincolor->setColor(d_minpen.color());
      
      inp_left->setChecked(d_axisenable[yLeft]);
      inp_right->setChecked(d_axisenable[yRight]);
      inp_top->setChecked(d_axisenable[xTop]);
      inp_bottom->setChecked(d_axisenable[xBottom]);
      
      if(d_xgrid==xBottom)inp_xgrid->setCurrentItem(0);
      else inp_xgrid->setCurrentItem(1);
      if(d_ygrid==yLeft)inp_ygrid->setCurrentItem(0);
      else inp_ygrid->setCurrentItem(1);
   }
}

void GraphGrid::loadOld()
{
   int i;
   
   if(series!=NULL){
      series->setGridAxis(d_xgrid);
      series->setGridAxis(d_ygrid);
      series->enableGridX(d_majx);
      series->enableGridY(d_majy);
      series->enableGridXMin(d_minx);
      series->enableGridYMin(d_miny);
      series->setGridMajPen(d_majpen);
      series->setGridMinPen(d_minpen);
      for(i=0;i<axisCnt;++i)
	series->enableAxis(i,d_axisenable[i]);
   }
}

void GraphGrid::loadBack(void)
{
   QPen pen;
   int tmp;
   
   if(series!=NULL){
      series->enableGridX(inp_majx->isChecked());
      series->enableGridY(inp_majy->isChecked());
      series->enableGridXMin(inp_minx->isChecked());
      series->enableGridYMin(inp_miny->isChecked());
      
      pen.setColor(inp_majcolor->color());
      pen.setWidth(atoi(inp_majwidth->text()));
      pen.setStyle((PenStyle)(inp_majstyle->currentItem()));
      series->setGridMajPen(pen);
      
      pen.setColor(inp_mincolor->color());
      pen.setWidth(atoi(inp_minwidth->text()));
      pen.setStyle((PenStyle)(inp_minstyle->currentItem()));
      series->setGridMinPen(pen);
      
      if(inp_xgrid->currentItem()==0)tmp=xBottom;
      else tmp=xTop;
      series->setGridAxis(tmp);
      if(inp_ygrid->currentItem()==0)tmp=yLeft;
      else tmp=yRight;
      series->setGridAxis(tmp);
      
      series->enableAxis(yLeft,inp_left->isChecked());
      series->enableAxis(yRight,inp_right->isChecked());
      series->enableAxis(xTop,inp_top->isChecked());
      series->enableAxis(xBottom,inp_bottom->isChecked());
   }
}
