/* stockinfo.cpp
 *
 * Andreas Wst
 *
 */

#include "stockinfo.moc"

StockInfo::StockInfo ( QWidget *parent, const char *name, int nr)
                     : QDialog ( parent, name, TRUE )
{
  setCaption ("Stock Info");

  config_data.browser = nr;

  fr = new QFrame (this);
  fr->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  fr->setLineWidth (2);
  fr->setGeometry (10, 10, 400, 300);
 
  lv = new QListView (fr, "lv");
  lv->setGeometry (2, 2, fr->width () - 4, fr->height () - 4);
  lv->addColumn ("Stock", 140);
  lv->addColumn ("WKN", 55);
  lv->addColumn ("Ticker Symbol", 90);
  lv->addColumn ("Market", 90);
  lv->setAllColumnsShowFocus (TRUE);
  connect (lv, SIGNAL (currentChanged (QListViewItem *)), this,
               SLOT (getCurrentItem (QListViewItem *)));

  connect (lv, SIGNAL (rightButtonPressed 
               (QListViewItem *, const QPoint &, int)), this,
               SLOT (openPopupInListView
               (QListViewItem *, const QPoint &, int)));
 

  ok = new QPushButton ("OK", this, "ok");
  ok->setGeometry (350, 330, 70, 30);
  connect (ok, SIGNAL (clicked ()), SLOT (accept ()));

  loadList ();

  currentStock = new Stock (0, "DUMMY", "000 000", 0.0);

  resize (430, 360);
}


void StockInfo::loadList ()
{
  char st [80];
  char dummy [80];
  char swkn [7];
  char smarket [25];
  QString sname, sticker;

  FILE *in;
  QString file (getenv ("KDEDIR"));
  file += "/share/apps/kstocks/l.list";

  if ((in = fopen (file.data (), "rt")) == NULL)
  { 
    fprintf (stderr, "Error opening l.list - file !");
  }
  else
  {
    while (fgets (st, 78, in) != NULL)
    {  
      // alte dummy variable lschen
      memset (dummy, 0, sizeof (dummy));
      memcpy (dummy, &st [37], 30);
      sname = dummy;
      sname.replace (QRegExp ("\n"), 0);

      memset (swkn, 0, sizeof (swkn));
      memcpy (swkn, st, 7);
      swkn [7] = 0;
    
      memset (dummy, 0, sizeof (dummy));
      memcpy (dummy, &st [69], 6);
      sticker = dummy;
      sticker.replace (QRegExp ("\n"), 0);

      switch (st [8])
      {
        case '0' : strcpy (smarket, "DAX");
                   break;
        case '1' : strcpy (smarket, "M-DAX");
                   break;
        case '2' : strcpy (smarket, "EURO-STOXX");
                   break;
        case '3' : strcpy (smarket, "Neuer Markt");
                   break;
        case '4' : strcpy (smarket, "Ausland");
                   break;
        case '5' : strcpy (smarket, "Dow Jones");
                   break;
        case '6' : strcpy (smarket, "EASDAQ");
                   break;
      }
      QListViewItem *item = new QListViewItem (lv, sname, swkn, 
                                               sticker, smarket);
    }
  }



}


StockInfo::~StockInfo()
{
        
}



void StockInfo::getCurrentItem (QListViewItem *item)
{
  // aktuell ausgewhlte Aktie befindet sich in *item
  // WKN und Ticker Symbol in currenStock eintragen 
  currentStock->setKurzel ((char *) item->text (2));
  currentStock->setWKN ((char *) item->text (1));
}


void StockInfo::startBrowser (int index)
{
  QString browser ("Starting ");
  QString br;
  QString brend;

  switch (config_data.browser)
  {
    case 0 : browser += "Netscape !";
             br = "netscape http://";
             brend = "";
             break;
    case 1 : browser += "KFM !";
             br = "kfmclient openURL 'http://";
             brend = "'";
             break;
    case 2 : browser += "Opera !";
             br = "opera http://";
             brend = "";
             break;
  }
  KMsgBox::message (this, "KStocks", browser.data ());
  
  switch (index)
  {
    case 1 : debug ("%squote.yahoo.com/q?s=%s&d=t%s &", br.data (), 
                     currentStock->getKurzel (), brend.data ());
             break;
    case 2 : debug ("%sbiz.yahoo.com/c/%c/%s.html%s &", br.data (),
                     currentStock->getKurzel () [0], 
                     currentStock->getKurzel (), brend.data ());
             break;
    case 3 : debug ("%swww.quicken.com/investments/snapshot/?symbol=%s%s &", 
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 4 : debug ("%swww.quicken.com/investments/quotes/?symbol=%s%s &",
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 5 : debug ("%scbs.marketwatch.com/http2_data/squote.htx?"
                    "source=htx%%2Fhttp2_mw&tables=table&TICKER=%s%s &", 
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 6 : debug ("%swww.marketwatch.newsalert.com/bin/headlines?"
                    "Query=%s&SearchOption=ticker%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
             break;
    case 7 : debug ("%sqs2.cnnfn.com/tq/stockquote?symbols=%s%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
             break;
    case 8 : debug ("%sorca.zacks.com/plsql/freser/zbrc?"
                    "tick=%s&comp_id=main&search=5%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
  }

}


void StockInfo::openBrowserWithZacks ()
{
  startBrowser (8);
}

void StockInfo::openBrowserWithCNNFN ()
{
  startBrowser (7);
}

void StockInfo::openBrowserWithCBSMarketWatchNews ()
{
  startBrowser (6);
}

void StockInfo::openBrowserWithCBSMarketWatchHome ()
{
  startBrowser (5);
}

void StockInfo::openBrowserWithYahooHome ()
{
  startBrowser (1);
}

void StockInfo::openBrowserWithYahooGrades ()
{
  startBrowser (2);
}

void StockInfo::openBrowserWithQuickenSnapshot ()
{
  startBrowser (3);
} 


void StockInfo::openBrowserWithQuickenQuote ()
{
  startBrowser (4);
} 


void StockInfo::openPopupInListView (QListViewItem *, const QPoint &, int)
{  
  QString s;

  debug ("in open popupinlistview");

  // prfen, ob aktien gewhlt und gltiger tickername
  if (strcmp (currentStock->getKurzel (), "NONE") == 0)
  {
    // kein gltiger name
    debug ("identisch NONE");
    return;
  }

  debug ("111111");

  // POPUP QUICKEN
  popquicken = new QPopupMenu (NULL, "popquicken");
  s.sprintf ("%s SNAPSHOT", currentStock->getKurzel ());
  popquicken->insertItem (s.data (), this,
                          SLOT (openBrowserWithQuickenSnapshot ()));
  s.sprintf ("%s QUOTES", currentStock->getKurzel ()),
  popquicken->insertItem (s.data (), this,
                          SLOT (openBrowserWithQuickenQuote ()));

  // POPUP YAHOO
  popyahoo = new QPopupMenu (NULL, "popyahoo");
  s.sprintf ("%s HOME", currentStock->getKurzel ());
  popyahoo->insertItem (s.data (), this, 
                        SLOT (openBrowserWithYahooHome ()));
  s.sprintf ("%s UPGRADES & DOWNGRADES", currentStock->getKurzel ());
  popyahoo->insertItem (s.data (), this, 
                        SLOT (openBrowserWithYahooGrades ()));

  // POPUP CBS MARKET WATCH
  popcbs = new QPopupMenu (NULL, "popcbs");
  s.sprintf ("%s HOME", currentStock->getKurzel ());
  popcbs->insertItem (s.data (), this,
                      SLOT (openBrowserWithCBSMarketWatchHome ()));
  s.sprintf ("%s NEWS", currentStock->getKurzel ());
  popcbs->insertItem (s.data (), this,
                      SLOT (openBrowserWithCBSMarketWatchNews ()));

  // POPUP Container
  popup = new QPopupMenu (NULL, "popup");
  s.sprintf ("Ticker Symbol : %s", currentStock->getKurzel ());
  popup->insertItem (s.data ());
  popup->insertSeparator ();

  popup->insertItem ("Visit at YAHOO", popyahoo);

  popup->insertItem ("Visit at Quicken", popquicken);

  popup->insertItem ("Visit at CBS Market Watch", popcbs);

  popup->insertItem ("Stock Quote CNNFN", this,
                     SLOT (openBrowserWithCNNFN ())); 
 
  popup->insertItem ("Zacks' Company News", this,
                     SLOT (openBrowserWithZacks ()));


  debug ("vor ende");

  popup->exec (QCursor::pos ());

  delete popup;
  delete popyahoo;
  delete popcbs;
}



