/* mywidget.cpp
 
  (c) 1999 Andreas Wst
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  */



#include "includes.h"

#include "defines.h"

#include "mywidget.moc"


KApplication *mywidget;



// ##########################
// #	class MyWidget      #
// ##########################


void MyWidget::createToolBar ()
{
  tb = new KToolBar (this);

  KIconLoader *il =kapp->getIconLoader ();

  tb->insertButton (il->loadIcon ("exit.xpm"), ID_QUIT, TRUE, i18n ("Quit"));
  tb->insertButton (il->loadIcon ("filenew.xpm"), ID_NEW, TRUE, 
                    i18n ("New Deposit"));
  tb->insertButton (il->loadIcon ("fileopen.xpm"), ID_OPEN, TRUE,
                    i18n ("Load Deposit"));
  tb->insertButton (il->loadIcon ("filefloppy.xpm"), ID_SAVE, TRUE,
                    i18n ("Save Deposit"));
  tb->insertButton (il->loadIcon ("help.xpm"), ID_HELP, TRUE, i18n ("Help"));
  tb->show ();
  addToolBar (tb);
  connect (tb, SIGNAL (clicked (int)), this, SLOT (getToolBarOption (int)));
}   


void MyWidget::createMenu()
{
  file = new QPopupMenu();	
  file->insertItem (i18n ("New deposit"), this, SLOT (newDepot ()));
  file->insertSeparator (-1);
  file->insertItem (i18n ("Load deposit"), this, SLOT (loadDialog ()));
  file->insertItem (i18n ("Save deposit"), this, SLOT (saveDepot ()));	
  file->insertItem (i18n ("Save deposit as"), this, SLOT (saveDialog ()));
  file->insertSeparator (-1);
  file->insertItem (i18n ("&Quit"), this, SLOT(quitapp()));

  stocks = new QPopupMenu ();
  stocks->insertItem (i18n ("Add Stock"), this, SLOT (newDialog ()));
  stocks->insertItem (i18n ("Edit Stock"), this, SLOT (editStock ()));
  stocks->insertItem (i18n ("Kill Stock"), this, SLOT (killStock ()));
  stocks->insertItem (i18n ("Merge Stocks"), this, SLOT (mergeStocks ()));
  stocks->insertItem (i18n ("Current Prices"), this, SLOT (editAktKurse ()));
  stocks->insertItem (i18n ("Splitt Stock"), this, SLOT (showSplit ()));
  stocks->insertItem (i18n ("Stock Info"), this, SLOT (stockInfoDialog ()));

  suche = new QPopupMenu ();
  suche->insertItem (i18n ("Look for WKN/Company"), this, SLOT (sucheWKN ()));

  chart = new QPopupMenu ();
  chart->insertItem (i18n ("Chart"), this, SLOT (showChart ()));
       
  options = new QPopupMenu();
  options->insertItem (i18n ("&Configuration"), this, SLOT (setConfig ()));
  //  options->insertItem (klocale->translate("&Configure keys"),
  //                       this, SLOT(configkeys()));

  help = new QPopupMenu();
  help->insertItem (i18n ("&Contents    F1"), this, SLOT(helpmenu()) );
  help->insertItem (i18n ("&About..."), this, SLOT(about()) );
	

  menu = new KMenuBar (this, "menu");
  menu->insertItem (i18n ("&File"), file, 5);
  menu->insertItem (i18n ("S&tocks"), stocks);
  menu->insertItem (i18n ("&Search"), suche);
  menu->insertItem (i18n ("&Chart"), chart);
  menu->insertItem (i18n ("&Options"), options);

  menu->insertSeparator(-1);
  menu->insertItem (i18n ("&Help"), help);

  menu->show ();
  menu->enableMoving (TRUE);
  menu->enableFloating (TRUE);

  setMenu(menu);
  updateRects ();
  
 //  connect (menu, SIGNAL (moved (menuPosition)), this, 
  //           SLOT (getMenuBarPos (menuPosition)));
}


void MyWidget::helpmenu()
{
	KApplication::getKApplication()->invokeHTMLHelp("","");
}

// initKeys und configkeys werden vorlufig wieder aus der kstock-version 0.0.4
// herausgenommen, da kkey offensichtlich bei neueren qt version > 1.42 auf 
// fehler luft -> bis zur endgltigen klrung entfernt !!!

/*
void MyWidget::configkeys()
{
	kKeys->configureKeys(this);
}


void MyWidget::initKeys()
{
  // here we create to shortcuts according to
  // the standard Kde keybinding
  accel = new KStdAccel(config);
	
  kKeys->addKey("About", "CTRL+A");
  kKeys->addKey("Contents", accel->help() );
  kKeys->addKey("Quit", accel->quit() );

  kKeys->registerWidget("top", this);
  kKeys->connectFunction ("top", "Contents", this, SLOT(helpmenu()) );
  kKeys->connectFunction("top", "Quit", this, SLOT(quitapp()) );
  kKeys->connectFunction("top", "About", this, SLOT(about()) );
}
*/


void MyWidget::putStockInListView (Stock s)
{
  char st [6] [20];
  sprintf (st [0], "%05d", s.getAnzahl ());
  strcpy (st [0], killOhs (st [0]));
  sprintf (st [1], "%08.2f", s.getGesamtWert ());
  strcpy (st [1], killOhs (st [1]));
  sprintf (st [2], "%08.2f", s.getKaufKurs ());
  strcpy (st [2], killOhs (st [2]));
  sprintf (st [3], "%08.2f", s.getAktKurs ());
  strcpy (st [3], killOhs (st [3]));
  sprintf (st [4], "%08.2f %%", fabs (s.gewinnProzent ()));
  strcpy (st [4], killOhs (st [4]));
  sprintf (st [5], "%010.2f %c",  fabs (s.gewinnEuro ()), 
                                  cur [deposit_currency]);
  strcpy (st [5], killOhs (st [5]));
 

  if (s.gewinnProzent () < 0)
  {
    st [4] [0] = '-';
    st [5] [0] = '-';
  }
  else
  {
    st [4] [0] = '+';
    st [5] [0] = '+';
  }

  
  //  fprintf (stderr, "anzahl : %s \n", st [0]);

  /*  
  lv->insertItem (new QListViewItem (lv, s.getName (), s.getWKN (),
                  st [0], st [1], st [2], st [3], st [4], st [5]));
  */
		  
  QListViewItem *item = new QListViewItem (lv, s.getName (), s.getWKN (),
                                           st [0], st [1], st [2], st [3],
                                           st [4], st [5]);
		 
}





void MyWidget::initConfig()
{
  config = kapp->getConfig();	

  config->setGroup ("BROWSER");
  
  // wenn browser eintrag vorhanden, dann ist rest auch vorhanden !
  if (config->hasKey ("Browser"))
  {
    config_data.browser = config->readNumEntry ("Browser");
  
    config->setGroup ("COLORS");
    config_data.col1 = config->readColorEntry ("Col1");
    config_data.col2 = config->readColorEntry ("Col2");
    config_data.col3 = config->readColorEntry ("Col3");
  }
  else  // wenn keine daten in config-file, vorbelegen mit standard
  {
    config_data.browser = 0;                // netscape
    config_data.col1 = QColor (255, 0, 0);  // red
    config_data.col2 = QColor (0, 255, 0);  // green
    config_data.col3 = QColor (0, 0, 255);  // blue
  }
}

void MyWidget::saveConfig()
{
  config->setGroup ("BROWSER");
  config->writeEntry ("Browser", config_data.browser);

  config->setGroup ("COLORS");
  config->writeEntry ("Col1", config_data.col1);
  config->writeEntry ("Col2", config_data.col2);
  config->writeEntry ("Col3", config_data.col3);

  config->sync();
}


MyWidget::MyWidget ( QWidget *, const char* name )
	: KTopLevelWidget ( name ), gesanz (0), 
          deposit_name (QString ("")), logoy (385)
{
  int i;
  setCaption (CAPTION);

  initConfig ();
  createMenu ();
  createToolBar ();

  //  initKeys();
 
  for (i = 0; i < 30; i++)
  {
    stock [i] = NULL;
  }


  container = new QWidget (this, "container");
  container->setFixedSize (700, 435); 
  setView (container);

  gb1 = new QGroupBox ("Deposit", container, "gb1");
  gb1->setGeometry (5, 5, container->width () - 10, 300);
   
  gb2 = new QGroupBox ("Overall Performance", container, "gb2");
  gb2->setGeometry (5, 310, 460, 120);

  gb3 = new QGroupBox ("Company Logo", container, "gb3");
  gb3->setGeometry (470, 310, 225, 120);

  fr = new QFrame (gb1);
  fr->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  fr->setLineWidth (2);
  fr->setGeometry (10, 20, gb1->width () - 20, gb1->height () - 30);

  fr2 = new QFrame (gb3);
  fr2->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  fr2->setLineWidth (2);
  fr2->setGeometry (10, 20, gb3->width () - 20, gb3->height () - 30);
 


  lv = new QListView (fr, "lv");
  lv->setGeometry (2, 2, fr->width () - 4, fr->height () - 4);
  lv->addColumn ("Stock", 140);
  lv->addColumn ("WKN", 55);
  lv->addColumn ("Number", 61);
  lv->addColumn ("Investment", 80);
  lv->addColumn ("Price", 70);
  lv->addColumn ("Cur. Price", 70);
  lv->addColumn ("Profit %", 80);
  lv->addColumn ("Profit $", 80);
  lv->setSorting (2, FALSE);
  lv->setAllColumnsShowFocus (TRUE);
  // rechtsbndig anordnen
  for (i = 1; i < 9; i++)
    lv->setColumnAlignment (i, 290);


  connect (lv, SIGNAL (currentChanged (QListViewItem *)), this, 
               SLOT (getCurrentItem (QListViewItem *)));
  connect (lv, SIGNAL (rightButtonPressed 
               (QListViewItem *, const QPoint &, int)), this, 
               SLOT (openPopupInListView 
               (QListViewItem *, const QPoint &, int)));
  


  QLabel *l = new QLabel ("Inv. deposit value :", gb2, "l");
  l->setGeometry (10, 30, 120, 30);
  l->setAlignment (AlignRight | AlignCenter);

  linvest = new QLabel ("", gb2, "l");
  linvest->setGeometry (145, 30, 90, 30);
  linvest->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  linvest->setAlignment (AlignRight | AlignCenter);

   
  l = new QLabel ("Cur. deposit value :", gb2, "l");
  l->setGeometry (10, 70, 120, 30);
  l->setAlignment (AlignRight | AlignCenter);

  laktinvest = new QLabel ("", gb2, "l");
  laktinvest->setGeometry (145, 70, 90, 30);
  laktinvest->setAlignment (AlignRight);
  laktinvest->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  laktinvest->setAlignment (AlignRight | AlignCenter);


  // zweite reihe
  
  l = new QLabel ("Profit in % :", gb2, "l");
  l->setGeometry (260, 30, 80, 30);
  l->setAlignment (AlignRight | AlignCenter);

  lproz = new QLabel ("", gb2, "l");
  lproz->setGeometry (350, 30, 90, 30);
  lproz->setAlignment (AlignRight | AlignCenter);
  lproz->setFrameStyle (QFrame::Panel | QFrame::Sunken);

  lcur = new QLabel ("Profit in $ :", gb2, "l");
  lcur->setGeometry (260, 70, 80, 30);
  lcur->setAlignment (AlignRight | AlignCenter);

  leuro = new QLabel ("", gb2, "l");
  leuro->setGeometry (350, 70, 90, 30);
  leuro->setAlignment (AlignRight | AlignCenter);
  leuro->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  
  //  setFixedSize (WIDTH, HEIGHT);

  updateRects ();
  //  resize (WIDTH, HEIGHT);


  
  llogo = new QLabel (fr2, "llogo"); 
  llogo->setGeometry (2, 2, fr2->width () -4, fr2->height () - 4);
  llogo->setBackgroundColor (QColor (255, 255, 255));
  
  //  llogo->setPixmap ("/opt/kde/share/apps/kstocks/logos/deutschebank.gif");




  // prfen, ob $HOME/stocks im jeweiligen homeverzeichnis existiert
  // wenn nicht -> errichten von $HOME/stocks und
  //                             $HOME/stocks/data

  QString home (getenv ("HOME"));
  home += "/stocks";

  QDir dir;
  if (dir.exists (home.data ()) == FALSE)
  {
    QString s;
    s.sprintf ("%s does not exist !\nCreate directory now !", home.data ());
    KMsgBox::message (this, "Installation KStocks", s.data ());
    dir.mkdir (home.data ());
    home += "/data";
    dir.mkdir (home.data ());
  }

  // current mit anfangswerten belegen
  currentStock = new Stock (0, "DUMMY", "000 000", 0.0);
  currentStock->setKurzel ("NONE");
}

MyWidget::~MyWidget()
{
}

void MyWidget::startBrowser (int index)
{
  QString browser ("Starting ");
  QString br;
  QString brend;

  switch (config_data.browser)
  {
    case 0 : browser += "Netscape !";
             br = "netscape http://";
             brend = "";
             break;
    case 1 : browser += "KFM !";
             br = "kfmclient openURL 'http://";
             brend = "'";
             break;
    case 2 : browser += "Opera !";
             br = "opera http://";
             brend = "";
             break;
  }
  KMsgBox::message (this, "KStocks", browser.data ());
  
  switch (index)
  {
    case 1 : debug ("%squote.yahoo.com/q?s=%s&d=t%s &", br.data (), 
                     currentStock->getKurzel (), brend.data ());
             break;
    case 2 : debug ("%sbiz.yahoo.com/c/%c/%s.html%s &", br.data (),
                     currentStock->getKurzel () [0], 
                     currentStock->getKurzel (), brend.data ());
             break;
    case 3 : debug ("%swww.quicken.com/investments/snapshot/?symbol=%s%s &", 
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 4 : debug ("%swww.quicken.com/investments/quotes/?symbol=%s%s &",
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 5 : debug ("%scbs.marketwatch.com/http2_data/squote.htx?"
                    "source=htx%%2Fhttp2_mw&tables=table&TICKER=%s%s &", 
                     br.data (), currentStock->getKurzel (), brend.data ());
             break;
    case 6 : debug ("%swww.marketwatch.newsalert.com/bin/headlines?"
                    "Query=%s&SearchOption=ticker%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
             break;
    case 7 : debug ("%sqs2.cnnfn.com/tq/stockquote?symbols=%s%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
             break;
    case 8 : debug ("%sorca.zacks.com/plsql/freser/zbrc?"
                    "tick=%s&comp_id=main&search=5%s &", br.data (),
                     currentStock->getKurzel (), brend.data ());
  }

}


void MyWidget::openBrowserWithZacks ()
{
  startBrowser (8);
}

void MyWidget::openBrowserWithCNNFN ()
{
  startBrowser (7);
}

void MyWidget::openBrowserWithCBSMarketWatchNews ()
{
  startBrowser (6);
}

void MyWidget::openBrowserWithCBSMarketWatchHome ()
{
  startBrowser (5);
}

void MyWidget::openBrowserWithYahooHome ()
{
  startBrowser (1);
}

void MyWidget::openBrowserWithYahooGrades ()
{
  startBrowser (2);
}

void MyWidget::openBrowserWithQuickenSnapshot ()
{
  startBrowser (3);
} 


void MyWidget::openBrowserWithQuickenQuote ()
{
  startBrowser (4);
} 

void MyWidget::getToolBarOption (int id)
{
  switch (id)
  {
    case ID_QUIT : quitapp ();
                   break;
    case ID_NEW  : newDepot ();
                   break;
    case ID_OPEN : loadDialog ();
                   break;
    case ID_SAVE : saveDepot ();
                   break;
    case ID_HELP : helpmenu ();
                   break;
  }
}


void MyWidget::getDepositData (QString s, unsigned char i)
{
  debug (s.data ());
  deposit_name = s;
  debug ("%d", i);
  deposit_currency = i;
  setCaption ((QString ("KStocks - ") + s).data ());

  // currency in listview header anpassen
  //    char cur [4] = {"E$Y"};
  char str [15];
  sprintf (str, "Profit %c", cur [deposit_currency]);
  lv->setColumnText (7, str);

  sprintf (str, "Profit in %c :", cur [deposit_currency]);
  lcur->setText (str);
}

void MyWidget::stockInfoDialog ()
{
  StockInfo *si;
  si = new StockInfo (this, "stockinfo", config_data.browser);
  si->exec ();
  delete si;
}

void MyWidget::openPopupInListView (QListViewItem *, const QPoint &, int)
{  
  QString s;

  // prfen, ob aktien gewhlt und gltiger tickername
  if (strcmp (currentStock->getKurzel (), "NONE") == 0)
  {
    // kein gltiger name
    debug ("identisch NONE");
    return;
  }


  // POPUP QUICKEN
  popquicken = new QPopupMenu (NULL, "popquicken");
  s.sprintf ("%s SNAPSHOT", currentStock->getKurzel ());
  popquicken->insertItem (klocale->translate (s.data ()), this,
                          SLOT (openBrowserWithQuickenSnapshot ()));
  s.sprintf ("%s QUOTES", currentStock->getKurzel ()),
  popquicken->insertItem (klocale->translate (s.data ()), this,
                          SLOT (openBrowserWithQuickenQuote ()));

  // POPUP YAHOO
  popyahoo = new QPopupMenu (NULL, "popyahoo");
  s.sprintf ("%s HOME", currentStock->getKurzel ());
  popyahoo->insertItem (klocale->translate (s.data ()), this, 
                        SLOT (openBrowserWithYahooHome ()));
  s.sprintf ("%s UPGRADES & DOWNGRADES", currentStock->getKurzel ());
  popyahoo->insertItem (klocale->translate (s.data ()), this, 
                        SLOT (openBrowserWithYahooGrades ()));

  // POPUP CBS MARKET WATCH
  popcbs = new QPopupMenu (NULL, "popcbs");
  s.sprintf ("%s HOME", currentStock->getKurzel ());
  popcbs->insertItem (klocale->translate (s.data ()), this,
                      SLOT (openBrowserWithCBSMarketWatchHome ()));
  s.sprintf ("%s NEWS", currentStock->getKurzel ());
  popcbs->insertItem (klocale->translate (s.data ()), this,
                      SLOT (openBrowserWithCBSMarketWatchNews ()));

  // POPUP Container
  popup = new QPopupMenu (NULL, "popup");
  s.sprintf ("Ticker Symbol : %s", currentStock->getKurzel ());
  popup->insertItem (klocale->translate (s.data ()));
  popup->insertSeparator ();

  popup->insertItem (klocale->translate ("Visit at YAHOO"), popyahoo);

  popup->insertItem (klocale->translate ("Visit at Quicken"), popquicken);

  popup->insertItem (klocale->translate ("Visit at CBS Market Watch"), popcbs);

  popup->insertItem (klocale->translate ("Stock Quote CNNFN"), this,
                     SLOT (openBrowserWithCNNFN ())); 
 
  popup->insertItem (klocale->translate ("Zacks' Company News"), this,
                     SLOT (openBrowserWithZacks ()));


  popup->exec (QCursor::pos ());

  delete popup;
  delete popyahoo;
  delete popcbs;
}



void MyWidget::setConfig ()
{
  ConfigDialog *cd = new ConfigDialog (this, "configdialog", &config_data);
  cd->exec ();
}

void MyWidget::getCurrentItem (QListViewItem *item)
{
  debug ("-------------------hole akt item-------------------------");
  bool found = FALSE;

  // wkn holen
  strcpy (gifname, item->text (1));
  debug ("wkn : %s", gifname);

  for (int i = 0; i < gesanz; i++)
  {
    if (strncmp (gifname, stock [i]->getWKN (), 7) == 0)
    {     
      debug ("%s ---- %s", gifname, stock [i]->getWKN ());
      found = TRUE;
      strcpy (gifname, stock [i]->getLogo ());
      debug ("gifname : %s", gifname);
      debug ("Krzel : -%s-", stock [i]->getKurzel ());
      debug ("netscape http://biz.yahoo.com/%s.html", stock [i]->getKurzel ());
      *currentStock = *stock [i];
      break;
    }
  }

  // wenn nicht in liste gefunden, dann gif mit leerstring belegen
  //  if (found == FALSE)
  //    gifname [0] = 0;

  repaint (FALSE);
}


void MyWidget::getMenuBarPos (menuPosition p)
{
  
  debug ("in get menubarpos");
  switch (p)
  {
    case Floating : resize  (WIDTH, HEIGHT - 30);
                    gb1->setGeometry (10, 10, 680, 300);
                    gb2->setGeometry (10, 340, 460, 100);
  fr->setGeometry (10, 20, 660, 260);
                    logoy = 355;
                    break;
    case Bottom :   resize (WIDTH, HEIGHT);
                    gb1->setGeometry (10, 10, 680, 300);
                    gb2->setGeometry (10, 340, 460, 100);
  fr->setGeometry (10, 20, 660, 260);
                    logoy = 355;
                    break;
    case Top :      resize (WIDTH, HEIGHT);
                    gb1->setGeometry (10, 40, 680, 300);
                    gb2->setGeometry (10, 370, 460, 100);
  fr->setGeometry (10, 20, 660, 260);
                    logoy = 385;
                    break;
  }
  
  updateRects ();
}


void MyWidget::showSplit ()
{
  // wenn kein depot geffnet ist, abbrechen
  if (deposit_name.length () == 0)
  {
    QMessageBox::critical (this, "Error", "You have to open a deposit\n"
                           "in order to split a stock !!", "&Ok"); 
    return;
  }

  // wenn keine vorhanden, dann abbrechen
  if (gesanz == 0)
  {
    QMessageBox::critical (this, "Error", "Deposit is empty, there are\n"
                           "no stocks to split !!", "&Ok"); 
    return;
  }

  Split *split;
  split = new Split (this, "split", gesanz, stock);
  switch (split->exec ())
  {
    case 1 :  // ok pressed -> gesplittet
             lv->clear ();
             for (int i = 0; i < gesanz; i++)
	     {
               putStockInListView (*(stock [i]));
	     }
             break;
  }   
  delete split;
  calculateOverallPerformance ();
}

void MyWidget::showChart ()
{
  ShowChart *chart;
  chart = new ShowChart (this, "showchart", config_data.col1, config_data.col2,
                         config_data.col3);
  chart->exec ();
  delete chart;
}

void MyWidget::sucheWKN ()
{
  WKNSuche *wkns;
  wkns = new WKNSuche (this, "wknsuche");
  wkns->exec ();
  delete wkns;
}


void MyWidget::editAktKurse ()
{
  // wenn kein depot geffnet ist, abbrechen
  if (deposit_name.length () == 0)
  {
    QMessageBox::critical (this, "Error", "You have to open a deposit\n"
                           "in order to enter prices !!", "&Ok"); 
    return;
  }

  // wenn keine vorhanden, dann abbrechen
  if (gesanz == 0)
  {
    QMessageBox::critical (this, "Error", "Deposit is empty, you can't\n"
                           "enter current prices !!", "&Ok"); 
    return;
  }

  NewAkt *newakt = new NewAkt (this, "newakt", gesanz, stock);
  newakt->exec ();
  delete newakt; 
  
  debug ("in editaktkurse , gesanz : %d", gesanz);

  lv->clear ();
 
  debug ("nach lv->clear ()");

  for (int i = 0; i < gesanz; i++)
  {
    debug ("index : %d", i);
    debug ("name : %s", stock [i]->getName ());
    putStockInListView (*(stock [i]));
  }
  
  debug ("nach put stock in list view");

  calculateOverallPerformance ();
}

void MyWidget::mergeStocks ()
{
  int exitcode;
  
  // wenn kein depot geffnet ist, abbrechen
  if (deposit_name.length () == 0)
  {
    QMessageBox::critical (this, "Error", "You have to open a deposit\n"
                           "in order to merge stocks !!", "&Ok"); 
    return;
  }

  // wenn keine zwei aktien vorhanden, dann abbrechen
  if (gesanz < 2)
  {
    QMessageBox::critical (this, "Error", 
                 "There are not enough stocks in your\n"
                 "deposit. No stocks to merge !", "&Ok"); 
    return;
  }


  Merge *merge = new Merge (this, "merge", gesanz, stock);
  exitcode = merge->exec ();
  if (exitcode != 0)
  {
    // wieder zurcksetzen
    exitcode--;
    int i1, i2;
    // index der ersten und zweiten aktie
    i1 = exitcode & 0xff;
    i2 = exitcode >> 8;
    debug ("erste  aktie : %s", stock [i1]->getName ());
    debug ("zweite aktie : %s", stock [i2]->getName ());
    
    // aktien mergen !
    stock [i1]->mergeStocks (*(stock [i2]));

   // wenn nicht letztes element, inhalt gewhltes, inhalt letztes tauschen
    if (i2 != (gesanz - 1))
    {
      *stock [i2] = *stock [gesanz - 1];
    }

    // anzahl reduzieren, speicher freigeben, stock = NULL 
    gesanz--;
    delete stock [gesanz];
    stock [gesanz] = NULL;


    lv->clear ();
    for (int i = 0; i < gesanz; i++)
    {
      putStockInListView (*(stock [i]));
    }

  }
  delete merge;
}

void MyWidget::killStock ()
{
  enum STOCK_STATUS status;

  // wenn kein depot geffnet ist, abbrechen
  if (deposit_name.length () == 0)
  {
    QMessageBox::critical (this, "Error", "You have to open a deposit\n"
                           "in order to delete a stock !!", "&Ok"); 
    return;
  }

  // wenn keine vorhanden, dann abbrechen
  if (gesanz == 0)
  {
    QMessageBox::critical (this, "Error", "Deposit is empty, there are\n"
                           "no stocks to delete !!", "&Ok"); 
    return;
  }






  // kill dialog ffnen
  Kill *kill = new Kill (this, "kill", gesanz, stock);
  kill->exec ();
  delete kill;

  // alle Stock nach KILLED-Flag durchsuchen und markierte entfernen
  for (int i = 0; i < gesanz; i++)
  {
    status = (enum STOCK_STATUS) stock [i]->getStatus ();
    if (status == KILLED)
    {
      debug ("killed : %s", stock [i]->getName ());
     
      int j = i;
      // letztes element nocht nicht erreicht
      while (j + 1 != gesanz)
      {
        *stock [j] = *stock [j + 1];
        j++;
      }

      // anzahl reduzieren, speicher freigeben, stock = NULL 
      gesanz--;
      delete stock [gesanz];
      stock [gesanz] = NULL;
      i = -1;
    }

  }

  // List-View lschen und Aktien eintragen
  lv->clear ();
  for (int i = 0; i < gesanz; i++)
  {
    putStockInListView (*(stock [i]));
  }

  memset (gifname, 0, sizeof (gifname));
}


void MyWidget::getAdded (bool b)
{
  if (b == TRUE)
    gesanz++;
}

void MyWidget::editStock ()
{
  int i;

  if (deposit_name.length () == 0)
  {
    QMessageBox::critical (this, "Error", "You have to open a deposit\n"
                           "in order to edit a stock !!", "&Ok"); 
    return;
  }

  if (gesanz == 0)
  {
    QMessageBox::critical (this, "Error", "Deposit is empty, there are\n"
                                 "no stocks to edit !!", "&Ok");
    return;
  } 



  EditStock *editstock;
  editstock = new EditStock (this, "edit", gesanz, stock);
  editstock->exec ();
  delete editstock;

  lv->clear ();

  for (i = 0; i < gesanz; i++)
    putStockInListView (*(stock [i]));

  /*
  i = 0;
  while (stock [i] != NULL)
  {
    debug (stock [i]->getName ());
    i++;
  }
  debug ("ende editselect");
  */

}

void MyWidget::getStock (Stock s)
{
  debug ("name aktie : %s", s.getName ());
  int i = 0;
  while (stock [i] != NULL) i++;

  debug ("Anzahl der bisherigen Eintrge : %d", i);

  stock [i] = new Stock (s.getAnzahl (), s.getName (), s.getWKN (), 
                         s.getKaufKurs ());
                         
  putStockInListView (s);

}

void MyWidget::newDialog ()
{
  debug ("new dialog");
  if (deposit_name.length () == 0)
  {
    QMessageBox::critical (this, "Error", "You have to open a deposit\n"
                           "in order to add a stock !!", "&Ok"); 
    return;
  }


  AddStock *add;
  add = new AddStock (this, "add");
  connect (add, SIGNAL (E_Stock (Stock)), SLOT (getStock (Stock)));
  connect (add, SIGNAL (E_added (bool)), SLOT (getAdded (bool)));
  add->exec (); 
  delete add;

  // neuladen aller logos  
  loadLogos ();
}

char * MyWidget::killOhs (char *st1)
{
  int i = 0;
  while (st1 [i] == '0')
  {
    st1 [i] = ' '; // '_'
    i++;
  }
  return st1;
}

void MyWidget::loadLogos ()
{
  FILE *in;
  char daten [78];
 
  QString st (getenv ("KDEDIR"));
  st += "/share/apps/kstocks/l.list";
  if ((in = fopen (st.data (), "rt")) == NULL)
  {
    fprintf (stderr, "Error loading l.list (%s)\n", st.data ());
  }
  else
  {
    // fr jede aktie logoname suchen
    for (int i = 0; i < gesanz; i++)
    {
      // logoname mit leerstring vorbelegen 
      stock [i]->setLogo ("");

      // an file - anfang
      fseek (in, 0, SEEK_SET);

      while (fgets (daten, 78, in) != 0)
      {

        // vergleich luft ber die wkns
        if (strncmp (daten, stock [i]->getWKN (), 7) == 0)
	{
          // gif - filename kopieren und in stock [i]->setlogo eintragen
          char dummy [20];
          strncpy (dummy, &daten [10], 19);
          dummy [19] = 0;
          QString hname (dummy);
          // berflssige leerzeichen entfernen, am ende des strings
          hname.replace (QRegExp (" "), "");
          stock [i]->setLogo (hname.data ());
          // Krzel noch einlesen und speichern
          strncpy (dummy, &daten [69], 8);
          dummy [8] = 0;
          hname = dummy;
          hname.replace (QRegExp (" "), "");
          hname.replace (QRegExp ("\n"), "");
          stock [i]->setKurzel (hname.data ());
          debug ("loadlogos : %s", daten);
	}

      }
    }
    fclose (in);
  }
}


void MyWidget::calculateOverallPerformance ()
{
  double summe = 0.0, summeakt = 0.0;
  for (int i = 0; i < gesanz; i++)
  {
    summe = summe + (stock [i]->getAnzahl () * stock [i]->getKaufKurs ());
    summeakt = summeakt + (stock [i]->getAnzahl () * stock [i]->getAktKurs ());
  }

  char st [23];
  sprintf (st, "%.2f %c", summe, cur [deposit_currency]);
  linvest->setText (st);

  sprintf (st, "%.2f %c", summeakt, cur [deposit_currency]);
  laktinvest->setText (st);

  sprintf (st, "%.2f %%", summeakt * 100 / summe - 100);
  lproz->setText (st);

  sprintf (st, "%.2f %c", summeakt - summe, cur [deposit_currency]);
  leuro->setText (st);
  fprintf (stderr, "%.2f", summeakt - summe);


}

void MyWidget::newDepot ()
{
  Newdeposit *nd;
  nd = new Newdeposit (this, "nd");
  connect (nd, SIGNAL (emitDepositData (QString, unsigned char)),
           this, SLOT (getDepositData (QString, unsigned char)));
  int ret =  nd->exec ();
  delete nd;

  // wenn listview gefllt und ok gedrckt
  if ((gesanz != 0) && (ret != 0))
  {
    // Labels in overall performance lschen
    linvest->setText ("");
    laktinvest->setText ("");
    lproz->setText ("");
    leuro->setText ("");

    // gifname lschen
    strcpy (gifname, "");

    // alte caption
    //    setCaption (CAPTION);
    // listview lschen 
    lv->clear ();
    // einzelne stocks lschen
    for (int i = 0; i < gesanz; i++)
    {
      delete stock [i];
    }
    gesanz = 0;
  }
}

void MyWidget::saveDepot ()
{
  // wenn kein depot geffnet ist, abbrechen
  if (deposit_name.length () == 0)
  {
    QMessageBox::critical (this, "Error", "You have to open a deposit\n"
                           "in order to save it !!", "&Ok"); 
    return;
  }

  debug ("Depot saved");
  if (deposit_name != "")
    saveDepotData (deposit_name.data ());
}
  
void MyWidget::saveDialog ()
{

  // wenn kein depot geffnet ist, abbrechen
  if (deposit_name.length () == 0)
  {
    QMessageBox::critical (this, "Error", "You have to open a deposit\n"
                           "in order to save it !!", "&Ok"); 
    return;
  }

  QString home (getenv ("HOME"));
  home += "/stocks";
  QString fileStr=QFileDialog::getSaveFileName(home.data (), "*.deposit",this);
  if (!fileStr.isEmpty ())
  {
    debug ("Eingabe, : %s", fileStr.data ());
    saveDepotData (fileStr.data ());
  }
  else
    debug ("keine Eingabe");
}

void MyWidget::saveDepotData (const char *f)
{
  // aktien auf aktuellen stand speichern
  FILE *out = stdout;

  if ((out = fopen (f, "wt")) == NULL)
  {
    fprintf (stderr, "Error saving deposit - file %s\n", f);
  }
  else
  {
    // header, currency   
    fprintf (out, "[KSTOCKS DEPOSIT]\n%d\n", deposit_currency);
  
    // daten der einzelnen aktien     
    for (int i = 0; i < gesanz; i++)
    {
      fprintf (out, "%d\n%f\n%f\n%s\n%s\n", stock [i]->getAnzahl (), 
                                            stock [i]->getKaufKurs (),
                                            stock [i]->getAktKurs (),
                                            stock [i]->getName (),
                                            stock [i]->getWKN ());
    }
    fclose (out);
  }
}    




void MyWidget::loadDialog () 
{
  QString home (getenv ("HOME"));
  home += "/stocks";
  debug ("load dialog : %s", home.data ());
  QString fileStr=QFileDialog::getOpenFileName(home.data (), "*.deposit",this);
  if (!fileStr.isEmpty ())
  {
    loadDepotData (fileStr.data ());
  }
  else
    debug ("Error loading %s", fileStr.data ());
}

void MyWidget::loadDepotData (const char *f)
{
  FILE *in = stdin;
  STOCK_STATUS status = OK;

  debug ("\nLOAD %s", f);
  if ((in = fopen (f, "rt")) == NULL)
  {
    fprintf (stderr, "Error loading deposit - file %s\n", f);
  }
  else
  {
    char dummy [80];
    bool *ok;
    fgets (dummy, 78, in);
    fprintf (stdout, "%s", dummy);
    QString s (dummy);
    if (s != "[KSTOCKS DEPOSIT]\n")
    {
      QString msg;
      msg.sprintf ("File %s is not a valid\nKStocks deposit file !", f);
      QMessageBox::critical (this, "Error", msg, "&Ok");
      return;
    }

    // currency holen
    fgets (dummy, 78, in);
    s = dummy;
    deposit_currency = s.toInt (ok);
    if (*ok == FALSE)
    {
      QString msg;
      msg.sprintf ("File %s is not a valid\nKStocks deposit file !", f);
      QMessageBox::critical (this, "Error", msg, "&Ok");
      return;
    }

    // wenn bisher keine fehler aufgetreten sind, wird der rest soweit ok sein
    // altes depot lschen !

    // noch eintrge vorhanden ? dann lv eintrge lschen 
    if (gesanz != 0)
      lv->clear ();
  
    // alle vorhandenen eintrge in stock lschen
    for (int i = 0; i < gesanz; i++)
    {
      delete stock [i];
    }


    // deposit daten holen
    int i = 0;
    QString anz, name, wkn, kaufkurs, aktkurs;
    while (fgets (dummy, 78, in) != 0)
    {
      anz = dummy;

      fgets (dummy, 78, in);
      kaufkurs = dummy;

      fgets (dummy, 78, in);
      aktkurs = dummy;

      fgets (dummy, 78, in);
      name = dummy;
      name.replace (QRegExp ("\n"), 0);

      fgets (dummy, 78, in);
      wkn = dummy;
      wkn.replace (QRegExp ("\n"), 0);

      stock [i] = new Stock (anz.toInt (ok), name.data (), wkn.data (),
                             kaufkurs.toFloat (ok));
      stock [i]->setAktKurs (aktkurs.toFloat (ok));
      stock [i]->setStatus (status);
      putStockInListView (*(stock [i]));
      i++;
    }
    gesanz = i;
    fclose (in);

    s = "KStocks - ";
    s += f;
    setCaption (s);
    deposit_name = f;
    strcpy (gifname, "");

    // currency in listview header anpassen
    //    char cur [4] = {"E$Y"};
    char str [15];
    sprintf (str, "Profit %c", cur [deposit_currency]);
    lv->setColumnText (7, str);

    sprintf (str, "Profit in %c :", cur [deposit_currency]);
    lcur->setText (str);


  }
  // ticker symbol zurcksetzen
  currentStock->setKurzel ("NONE"); 
  calculateOverallPerformance ();
  loadLogos ();
}


void MyWidget::quitapp()
{
  saveConfig();
  mywidget->quit();	
}

void MyWidget::about()
{
  QString q;
  const char *msg = klocale->translate("A program written in"
                    " C++ using Qt/Kde.\nBased on my own code from 1999"
                    "\n\nWritten by Andreas Wst");
  q.sprintf("%s %s (%s)\n\n%s", NAME, VERSION, DATE, msg);
  KMsgBox::message(this, CAPTION, q );
}

/*
void MyWidget::mousePressEvent (QMouseEvent *m)
{
  debug ("mouse pressed");
}
*/

void MyWidget::notImpl()
{
  KMsgBox::message(this, CAPTION,
  klocale->translate("Sorry, this function hasn't been implemented yet...")  );
}


void MyWidget::paintEvent (QPaintEvent *)
{
  debug (" in repaint ");

  // wenn keine aktien in listview erst garnicht versuchen logo zu laden
  if (gesanz == 0)
  {
    return;
  }

  // in pm wird pixmap geladen
  QPixmap pm (205, 80);

  // in back wird pixmap zentriert hereinkopiert
  QPixmap back (205, 80);
  back.fill (QColor (255, 255, 255));


  QString st (getenv ("KDEDIR"));
  st += "/share/apps/kstocks/logos/";
  st += gifname;

  if (pm.load (st) == FALSE)
  {
    fprintf (stderr, "Error loading logo - file %s\n", st.data ());
    llogo->setPixmap (back);
  }
  else
  {
    bitBlt (&back, (103 - (pm.width () >> 1)), 
                   (40 - (pm.height () >> 1)), &pm);
    llogo->setPixmap (back);
  }

}
  
const char MyWidget::cur [4] = {"E$Y"};


// ##########################
// #	Main                #
// ##########################


int main(int argc, char **argv)
{
  KApplication a (argc, argv, "kstocks");


  MyWidget m;
  a.setMainWidget (&m);
  m.show ();
  return a.exec ();
}

