#include <kapp.h>
#include <kwizard.h>
#include <htmlview.h>
#include <qfile.h>

/**
 * This should probably be a kdehelp thing, but users seemed to just close
 * kdehelp when it popped up. Seems people are more likely to read
 * documentation if it looks like a wizard...
 *
 * Right now filenames are static because I've been busy, but this will soon
 * be able to read index files and is intended to be a bookreader type thing.
 */

static char *html_names[] ={"intro.html", "layout.html", "toolbar.html",
"editing.html", "concepts.html", "expressions.html", "functions.html",
"advanced.html"
};

#define PAGES 8

int main (int argc, char **argv)
{
    KApplication app(argc, argv);
    QString path = app.kde_datadir()+"/ksiag/guru/";
    KWizard wiz;
    QFile file;
    KHTMLView *view;
    KWizardPage *page;
    int i;
    char tmp[256];

    for(i=0; i< PAGES; ++i){
        file.setName(path + html_names[i]);
        if (file.open(IO_ReadOnly)){
            view = new KHTMLView(&wiz);
            page = new KWizardPage();
            view->begin(path+html_names[i]);
            view->parse();
            while(!file.atEnd()){
                file.readLine(tmp, 256);
                view->write(tmp);
            }
            view->end();
            page->w = view;
            page->title = "KSiag Guru Introduction";
            wiz.addPage(page);
            file.close();
        }
        else
            warning("Could not open tutorial page:%s!",
                    (const char*)(path+html_names[i]));
    }
    app.setMainWidget(&wiz);
    wiz.resize(615, 300); // Need something, might as well use the screenshot
    wiz.show();
    return (app.exec());
}


