#ifndef __KSIAGTOPLEVEL_H
#define __KSIAGTOPLEVEL_H

#include <stdio.h>
#include "../siag/calc.h"
#include <qtabbar.h>
#include <qscrollbar.h>
#include <ktmainwindow.h>
#include <kstatusbar.h>
#include "ksiag_popupmenu.h"
#include "ksiag_lineedit.h"
#include "ksiag_toolbar.h"
#include "ksiag_tableview.h"
#include "ksiag_dialogs.h"
/**
 * Provides the toplevel windows containing menus, toolbars, and status bars.
 * Note that KSiagTableManager handles the close events and menu popups.
 */

class KSiagTopLevel : public KTMainWindow
{
    Q_OBJECT
public:
    KSiagTopLevel (window *w, const char *name =0);
    ~KSiagTopLevel ();
    /**
     * Sets the label to the left of the input lineedit
     */
    void setLabelText (char *prompt) {input_label->setText(prompt);}
    /**
     * Main status message (the one on the right).
     */
    void setStatusMessage (const char *text)
        {stbar->changeItem(text, ID_STATUS_MSG);}
    /**
     * Cell type status message
     */
    void setStatusType (const char *text)
        {stbar->changeItem(text, ID_STATUS_TYPE);}
    KSiagLineEdit* lineEdit() {return(input_line);}
    KSiagTableView* view(){return(tblview);}
    void updateMenus (KSiagPopupMenu **menulist);
    KSiagPopupMenu* menuAt(int index) const;
    void activateShortcuts (const QPoint &pos);
    void updateControls();
signals:
    /**
     * Notify KSiagTableManager when we want to close.
     */
    void closeWindow (window *w);
protected:
    void closeEvent (QCloseEvent *ev);
    bool queryExit();

    KSiagTableView *tblview;
    QLabel *input_label;
    KSiagLineEdit *input_line;
    KStatusBar *stbar;
    KSiagPopupMenu *menus[11];

};


// ID's for menus, toolbars, etc...
#define ID_NEW       100
#define ID_OPEN      101
#define ID_SAVE      102
#define ID_PREVIEW   103
#define ID_PRINT     104
#define ID_PLOT      105
#define ID_SIGMA     106
#define ID_HELP      107
#define ID_GNU       108
#define ID_BORDER    109
#define ID_GRID      110
#define ID_ULINE     111
#define ID_NOGRID    112

#endif 

