
#ifndef __KSIAGPOPUPMENU_H
#define __KSIAGPOPUPMENU_H

/**
 * A popup menu that execs Lisp functions
 */

#define INCLUDE_MENUITEM_DEF
#include <qstrlist.h>
#include <qpopupmenu.h>

#define ID_MENU_FILE   		0
#define ID_MENU_EDIT   		1
#define ID_MENU_BLOCK  		2
#define ID_MENU_FORMAT 		3
#define ID_MENU_DATA   		4
#define ID_MENU_PLUGIN 		5
#define ID_MENU_WINDOW 		6
#define ID_MENU_PLOT   		7	
#define ID_MENU_TOOLS  		8
#define ID_MENU_HELP   		9
#define ID_MENU_SHORTCUTS 	10

class KSiagPopupMenu : public QPopupMenu
{
    Q_OBJECT
public:
    KSiagPopupMenu (QWidget *parent=0, const char *name=0);
    ~KSiagPopupMenu(){};
    void copy (KSiagPopupMenu *mnu);
    void addLispFunction (const char *name, const char *function);
    void insertSubmenu (const char *name);
    KSiagPopupMenu* findSubmenu (const char *name);
protected slots:
    void execLispFunction (int id);
protected:
    QList<KSiagPopupMenu> submenus;
    QStrList subnames;
    QStrList functions;
};


#endif

