
#include <stdio.h>
#include "ksiag_app.h"
#include "../siod/siod.h"
#include "../siag/calc.h"
#include "../siag/types.h"

extern window *w_list;

KSiagClipboard::KSiagClipboard()
{
    cb = KApplication::getKApplication()->clipboard();
    connect(cb, SIGNAL(dataChanged()), SLOT(clear()));
    copy_buffer = NULL;
}

KSiagClipboard::~KSiagClipboard()
{
    if (copy_buffer)
        free(copy_buffer);
}

void KSiagClipboard::clear()
{
    // We clear our buffer if QT clipboard changes, forcing QT's data.
    if (copy_buffer)
        free(copy_buffer);
}

void KSiagClipboard::copy()
{
    static char data_buf[32000];
    char *data = data_buf;
    long size;
    long r1 = w_list->blku.row;
    long c1 = w_list->blku.col;
    long r2 = w_list->blkl.row;
    long c2 = w_list->blkl.col;
    // Internal buffer
    if (copy_buffer)
        free(copy_buffer);
    copy_buffer = pack_area(w_list->buf, r1, c1, r2, c2, &size);
    // Text for QT clipboard, much the same as the Xt routine.
    buffer *b = w_list->buf;
    long r, c, lastr, lastc;
    char *p, *q;
    *data = '\0';
    q = data;
    lastr = line_last_used(b);
    if (lastr > r2)
        lastr = r2;
    for (r = r1; r <= lastr; r++) {
        lastc = col_last_used(b, r);
        if (lastc > c2)
            lastc = c2;
        for (c = c1; c <= lastc; c++) {
            if (data-q > 30000)
                return;
            p = ret_pvalue(NULL, b, r, c, -1);
            strcpy(data, p);
            data += strlen(data);
            if (c < c2)
                *data++ = ',';
        }
        *data++ = '\n';
    }
    *data++ = '\0';
    cb->setText(data_buf);
}

void KSiagClipboard::paste()
{
    buffer *b = w_list->buf;
    long row = w_list->point_pos.row;
    long col = w_list->point_pos.col;
    // Use internal formatted buffer if possible
    if (copy_buffer)
        unpack_area(b, copy_buffer, row, col);
    // More cut 'n pasted code from xsiag.
    else{
        char *data = const_cast <char *>(cb->text());
        if (!data)
            return;
        char *p;
        long n = 0;
        cval value;
        value.number = 0;
        for (p = data; *p; p++)
            if (*p == '\n')
                n++;
        undo_save(b, row, col, row+n, col);
        while ((p = strchr(data, '\n')) != NULL) {
            *p = '\0';
            ins_data(b, siod_interpreter, data,
                     value, LABEL, row, col);
            row++;
            data = p+1;
        }
        if (*data) {
            ins_data(b, siod_interpreter, data,
                     value, LABEL, row, col);
        }
    }
    KSiagApp::manager()->activeTable()->repaint(false);
}
