#include <string.h>
#include <stdio.h>
#include <stdlib.h>

//#include <qlist.h>

#include "action.h"
#include "matrix.h"
#include "np.h"


NPT::NPT(int )
{
  maxx=0;
  maxy=0;
  filename=0;
}

NPT::~NPT() 
{
  if (filename)
     delete [] filename;
}

int NPT::DelProc(int i) 
{
   return (int)(dur.remove(i));
}

int NPT::DelProc(int , int ) 
{
   return 0;/*dur->removeElem(x,y);*/
}

int NPT::AddProc(Action *a)
{
   if (a) {
      dur.append(a);
      return 1;
   } else
      return 0;
}

Action* NPT::GetProc(int i) 
{
   return dur.at(i);
}

Action *NPT::GetProc(int x, int y) 
{
   return dur.atxy(x,y);
}


void NPT::Clear()
{
   dur.clear();
}


   
void NPT::getFmtStr(int i, char *sz, char sep)
{
   Action *a=GetProc(i);
   if (!sz) return;
   
   if (a) {
      a->print(sz, sep);
   } else
      sz[0]=0;
}

int NPT::PerformTripel(int , int d)
{
/*
  int i,j,k;
  
  for(i=0; i<size; i++) {
    for(j=0;j<size;j++)
      if (dist->Get(i,j)==NELEM) dist->Set(i,j, MAXELEM);  
  }
  
  for(i=0; i<size; i++) 
    for(j=0;j<size;j++)
      for(k=0;k<size;k++) {
	if (i!=k && j!=k)
	  if(dist->Get(i,j)+dist->Get(k,i) < dist->Get(k,j))
	    dist->Set(k,j, dist->Get(k,i)+dist->Get(i,j));
      }*/
  return d;

}

int NPT::FeedForward(int y, int d)
{
  int i;
  Action *a;
  /* eval ebt */
  for (i=0; i<=dur.getSizeY() ; i++)
    if ((a=GetProc(y,i))) {
      if (a && d >= a->Get_ebt()) {
         a->Set_ebt(d);
         a->setIso(0); /* remove isolate flag */
      }
      if (d>pd) 
         pd=d;
      if (y>=maxy && i>maxx) {
         maxy=y;
         maxx=i;
      }

      FeedForward(a->getSucc(), a->getDur()+d);      
    }
  return d;
}

int NPT::FeedBackward(int y, int d)
{
  int i;
  Action *a;
  if (d<0 || y<0 ) return 0;
  /* eval let */

  for(i=0; i<=dur.getSizeX(); i++) {
     a=GetProc(i,y);
     //printf("(%d,%d),",i,y);
     if (a) {
        if (a->Get_let()>d/*-a->getDur()*/)
           a->Set_let(d/*-a->getDur()*/);
        FeedBackward(a->getPred(),d-a->getDur());
     }
  }

  return d;
}

int NPT::CalcTimes() 
{
  uint d, i;
  pd=0L;
  Action *b=0;

  maxx=0;
  maxy=0;
  d=FeedForward(0,0);/* calc ebt */
  
  for(i=0;i<dur.count(); i++) {
    b=GetProc(i);
    if (b) {
       b->Set_eet(b->Get_ebt()+b->getDur());
      if (b->Get_eet()>pd) { 
         pd =b->Get_eet(); 
      }
    }
  }
  
  for(i=0;i<dur.count(); i++) {
    b=GetProc(i);
    if (b) 
       b->Set_let(pd);
  }
  
  FeedBackward(dur.getSizeY(), pd);
  
  for(i=0;i<dur.count(); i++) {
    b=GetProc(i);
    if (b) {
       b->Set_lbt(b->Get_let()-b->getDur());
    }
  }
  return 0;
}


/* loading data from file. lines beginning with # are ignored.
   returns 0, if sucessful, otherwise -1 */
int NPT::loadFile(const char *sz)
{
   if (sz) {
      FILE *f;
      char *buffer=new char[200];
      printf("Open file %s...\n", sz);
      f=fopen(sz, "rt");
      if (f) {
         while (!feof(f)) {
            fgets(buffer,199,f);
            if (buffer[0]!=0 && buffer[0]!='#')
               evalString(buffer);          
         }
         fclose(f);
         if (filename)
            delete [] filename;
         filename = new char [strlen(sz)+1];
         ::strcpy(filename, sz);
         CalcTimes();
         return 0;
      }
      else
         return -1;
   }
   return -1;
}

int NPT::saveFile(const char *sz)
{
   Action *b=0;
   if (sz==0 && filename!=0)  /* use previous name */
      sz=filename;
   
   if (sz) {
      FILE *f;
      uint i;
      f=fopen(sz, "w+t");
      if (f) {
         for(i=0; i<dur.count(); i++) {
            b=GetProc(i);
            if (b)
               fprintf(f,"%ld:%ld:%ld:%s\n",
                  b->getPred(),
                  b->getSucc(),
                  b->getDur(),
                  b->getText());
         }
         fclose(f);     
         return dur.count();      
      }
   }
   return 0;
}

/* evalString 
 * ---------------------------
 * Purpose:		assign input string to appropiate fields in project plan
 */
int NPT::evalString(char *sz) {
   char *token;
   char sep[]=":\n";
   int count=0;
   long p=0L,s=0L,d=0L;
   
   token=strtok(sz, sep);
   while(token!=0) {
      switch(count) {
         case 0: /* Pred */
            p=atol(token);
//            printf("pred: %ld ", p);
            break;
        case 1: /* Succ */
           	s=atol(token);
//            printf("suc: %ld ", s);
            break;
        case 2: /* Dur */
            d=atol(token);
//            printf("dur: %ld ", d);
            break;
        case 3: /* Text */
            //p=atol(token);
//            printf("text: %s ", token);
            break; 
      }
      if (count==3)
         dur.inSort(new Action(p,s,d,token));
      count++;
      token=strtok(NULL,sep);         
   }   
   return count;
}


