#include <qwidget.h>
#include <qcolor.h>
#include <qbrush.h>
#include <qrect.h>
#include <qpainter.h>
#include <qscrbar.h>

#include "QwViewport.h"

#include "matrix.h"
#include "kpp_net.h"

QGantt::QGantt(QWidget *, const char *name,  QMatrix *l, long d) 
: QDialog(0, name)
{
   QwViewport *view = new QwViewport(this,"viewport");
   gantt = new QGanttWidget(view->portHole(),0,l,d);
   //gantt->show();
   view->resize(this->size());
   view->resizeScrollBars();
   gantt->show();
   view->show();  
   setCaption("GANTT-Diagram");
}
 
QGantt::~QGantt()
{
   delete gantt;
}

QGanttWidget::QGanttWidget (QWidget *w, const char *name, QMatrix *m, long p)
:QWidget(w, name)
{
   list=m;
   pd=p;
   setMinimumSize(pd * minbarx+2*xoff, list->count() * minbary+2*yoff);
   //resize(pd * minbarx+2*xoff, list->count() * minbary+yoff);
}

/*
QGanttWidget::QGanttWidget(QGanttWidget &w)
:QWidget(w.parent, w.name)
{
   list=w.list;
   pd=w.pd;
}
*/

void QGanttWidget::DrawNode(int i, Action *a)
{
   QPainter p(this);
   int blue=255/list->count()*i, y=yoff+i*minbary+(minbary/2);
   
   QPoint bl1(xoff+a->Get_ebt()*minbarx,y), 
          bl2(xoff+a->Get_let()*minbarx,y);
   QRect r=QRect( QPoint(bl1.x(),y-minbary/2),
                  QSize(a->getDur()*minbarx, 
                  minbary));
   QPen oldp;
   
   p.setPen(QPen(QColor(255,255,255),1));
   p.drawText(QPoint(bl2.x()+10, r.bottom()), a->getText());
   if (a->getCrit()) {
      p.fillRect(r, QBrush( QColor(255,0,0) ) );
   } else {
      p.setPen(QPen( QColor(0,0,blue),2, DashLine));
      p.drawLine(bl1,bl2);
      p.fillRect(r, QBrush( QColor(0,0,128) ) );      
   }
}

void QGanttWidget::DrawAll()
{
   if (!list) return;
   Action *a;
   
   DrawCoords();
   int count=0;
   for(a=list->first(); a!=0; a=list->next(), count++)
      DrawNode(count, a);
}

void QGanttWidget::DrawCoords()
{
   int x,y=yoff+minbary*list->count();
   QPainter p(this);
   QString s;
   int count=0, factor=5;
   
   p.setPen(QPen(QColor(0,0,0),1, DotLine));
   
   for(x=xoff; x<=xoff+minbarx*pd; x+=minbarx*factor,count+=factor) {
      p.drawLine(x, yoff-1, x, y);
      s.sprintf("%d",count);
      p.drawText(x-5,y+10,s);
   }
}

void QGanttWidget::paintEvent(QPaintEvent *p)
{
   QWidget::paintEvent(p);
   DrawAll();
}

