/*
 * $Id: qkstring.C,v 1.1 1998/02/01 19:24:59 kalle Exp $
 */

#include "qkstring.h"

uint QkString::tokenCount( const char separator ) const
{
  int count = 1;
  QkString scratch = copy();

  while( scratch.length() )
	{
	  int pos = scratch.find( separator );
	  if( pos == -1 )
		return count;
	  count++;
	  scratch = scratch.right( scratch.length() - pos - 1 );
	};
  
  return count;
}


QkString QkString::getToken( const uint num, 
							 const char separator = ',' ) const
{
  uint pos = 0;

  // skip the first num -1 separators
  for( uint i = 0;  i < num; i++ )
	{
	  int newpos = find( separator, pos );
	  if( newpos == -1 ) 
		return QkString();
	  pos = newpos + 1;
	};

  int last = find( separator, pos );
  if( last == -1 ) last = length();
  return mid( pos, last - pos );
}



/*
 * $Log: qkstring.C,v $
 * Revision 1.1  1998/02/01 19:24:59  kalle
 * Fixed bug with comboboxes in DocumentLayoutDialog
 *
 * Revision 1.3  1997/10/14 17:23:21  kalle
 * Functionality like isdnmon
 *
 * Revision 1.2  1997/10/13 19:57:10  kalle
 * Towards isdnmon-like functionality
 *
 */
