/* -*- mode: C++; c-file-style: "Stroustrup" -*-
 *
 * $Id: qkbrowser.h,v 1.5 1999/01/29 15:24:05 kuepper Exp $
 */

#ifndef KLYX_QKBROWSER_H
#define KLYX_QKBROWSER_H


#include <qwidget.h>
#include <qtablevw.h>
#include <qarray.h>


class QString;
class QPainter;
class QPixmap;


class QKBrowseBox : public QTableView
{
  Q_OBJECT
public:
  QKBrowseBox( int x, int y, QWidget* parent=0, const char* name=0, WFlags f=0 );
  ~QKBrowseBox();
  
  void insertItem( QString text, int x, int y );
  void insertItem( const char* text, int x, int y ) { insertItem( QString( text ), x, y ); }
  void insertItem( QPixmap pixmap, int x, int y );
  void removeItem( int x, int y );
  void clear();

  QString text( int x, int y );
  QPixmap pixmap( int x, int y);

  int exec( const QPoint& pos );
  int exec( int x, int y );
  int exec( const QWidget* trigger );

protected:
  virtual void keyPressEvent( QKeyEvent* e );
  virtual void resizeEvent( QResizeEvent* e );
  virtual void mouseReleaseEvent( QMouseEvent* e );
  virtual void mousePressEvent( QMouseEvent* e );
  virtual void mouseMoveEvent( QMouseEvent* e );
  virtual void paintCell( QPainter *, int, int );

private:
  int coordsToIndex( int x, int y );

  QString* _texts;
  QPixmap* _pixmaps;
  QPoint _activecell;
  bool _firstrelease,
       _mousepressed;
    
};


#endif
