/*
 *  File:        math_symbols.C
 *  Purpose:     User interface to math symbols
 *  Author:      Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 *  Created:     November 1995
 *  Version:     0.8 28/03/96
 *  Description: Provides a GUI to introduce mathematical
 *               symbols in lyx.
 *
 *  Dependencies: Xlib, XForms, Lyx
 *
 *  Copyright: (c) 1995, 1996, Alejandro Aguilar Sierra 
 *
 *   You are free to use and modify it under the terms of
 *   the GNU General Public Licence version 2 or later.
 */

#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include <stdlib.h>


#include "lyx_main.h"
#include "buffer.h"
#include "LyXView.h"
#include "BufferView.h"
#include "minibuffer.h"
#include "lyxrc.h"
#include "lyxlib.h"
#include <X11/Xutil.h>

#include "formula.h"

#include "math_parser.h"

// 	$Id: math_symbols.C,v 1.13 1998/04/16 22:45:20 kulow Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: math_symbols.C,v 1.13 1998/04/16 22:45:20 kulow Exp $";
#endif /* lint */

extern void SmallUpdate(signed char);
extern int UnlockInset(UpdatableInset*);
extern short greek_kb_flag;

// Needed for compose-key handling.
extern XComposeStatus compose_status;

extern BufferView *current_view;

/* Latex code for those bitmaps */
static char const *latex_greek[] =  {
   "Gamma", "Delta", "Theta", "Lambda", "Xi", "Pi",
   "Sigma", "Upsilon", "Phi", "Psi", "Omega",
   "alpha", "beta", "gamma", "delta", "epsilon", "varepsilon", "zeta",
   "eta", "theta", "vartheta", "iota", "kappa", "lambda", "mu",
   "nu", "xi", "pi", "varpi", "rho", "sigma", "varsigma",
   "tau", "upsilon", "phi", "varphi", "chi", "psi", "omega", ""
};

char const* latex_varsz[] = {
"sum", "int", "oint", 
"prod", "coprod", "bigsqcup", 
"bigotimes", "bigodot", "bigoplus", 
"bigcap", "bigcup", "biguplus", 
"bigvee", "bigwedge", ""
};

static signed char latin2greek[] =  {
  0, 1, 25, 3, 4, 23, 2, 7, 10, 24, 11, 12, 13, 14, -1, 16, 8, 18,
  19, 21, 22, 17, 27, 15, 26, 6
};
 
static signed char Latin2Greek[] =  {
 -1, -1, -1, 1, -1, 8, 0, -1, -1, -1, -1, 3, -1, -1, -1,
 5, 2, -1, 6, -1, 7, -1, 10, 4, 9, -1
}; 

extern char** mathed_get_pixmap_from_icon(int d);
void math_insert_symbol(char const* s);
Bool math_insert_greek(char const c);

Bool math_insert_greek(char const c)
{
   int i;
   char const *s=NULL;
   
   if ('A'<=c && c<='Z') {
      if ((i=Latin2Greek[c - 'A'])>=0)
	s = latex_greek[i];
   }   
   if ('a'<=c && c<='z') {
      if ((i=latin2greek[c - 'a'])>=0)
	s = latex_greek[i+11];
   }
   if (s) {
      math_insert_symbol(s);
      if (greek_kb_flag<2) {
	 greek_kb_flag = 0;
	 UnlockInset(current_view->currentBuffer()->the_locking_inset);
      }
      return True;
   } else
     return False; 
}

void math_insert_symbol(char const* s)
{
   if (current_view->available())   {
      if (!current_view->currentBuffer()->the_locking_inset) {
 	 InsetFormula* new_inset = new InsetFormula();
 	 current_view->getScreen()->HideCursor(true);
 	 current_view->currentBuffer()->insertInset(new_inset);
	 current_view->currentBuffer()->updateFull(); // Bug ?
 	 new_inset->Edit(0,0);
 	 new_inset->InsertSymbol(s);
      } else
	if (current_view->currentBuffer()->the_locking_inset->LyxCode()==Inset::MATH_CODE)
	  ((InsetFormula*)current_view->currentBuffer()->the_locking_inset)->InsertSymbol(s);
        else 
	  fprintf(stderr, "Math error: attempt to write on a wrong class of inset.\n");
   }
}

