/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich,
*           1995 - 1997 The LyX Team.
*
*======================================================*/

#include "klyx.h"
#include <kwm.h>
#include <config.h>

#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "LString.h"
#include "lyx_main.h"
#include "lyxfr0.h"
#include "lyxfr1.h"
#include "lyxfunc.h"
#include "lyxscreen.h"
#include "error.h"
#include "lyxtext.h"
#include "LyXView.h" // only because of form_main
#include "FindReplaceDialog.h"

extern BufferView* current_view;

//--------------------- LyXFindReplace0's implementation ------------

LyXFindReplace0::LyXFindReplace0()
{
  fCaseSensitive = false;
  fMatchWord = false;
}


void LyXFindReplace0::StartSearch()
{
	if( !klyxdialogs->findreplace )
		klyxdialogs->findreplace = new FindReplaceDialog( current_view->getOwner() );

	if( klyxdialogs->findreplace->isVisible() ){
	  klyxdialogs->findreplace->raise();
	  KWM::activate(klyxdialogs->findreplace->winId());
	}
	else
	  klyxdialogs->findreplace->show();

  ReInitFromForm();
}


void LyXFindReplace0::ReInitFromForm()
{
  lsSearch = klyxdialogs->findreplace->getSearchText();
  fCaseSensitive = klyxdialogs->findreplace->isCaseSensitive();
  fMatchWord = klyxdialogs->findreplace->isMatchWord();
}


// Returns the value of the replace string in the form
LString const LyXFindReplace0::ReplaceString()
{
  return LString( klyxdialogs->findreplace->getReplaceText().data() );
}


void LyXFindReplace0::SetReplaceEnabled(bool fEnable)
{
  fReplaceEnabled = fEnable;
  klyxdialogs->findreplace->setReplaceEnabled( fEnable );
}

void LyXFindReplace0::SetSearchString(LString const &ls)
{
  lsSearch = ls;
  klyxdialogs->findreplace->setSearchText( ls.c_str() );
}


//---------------------------------------------------------------
//HB??: Maybe _FR.StartSearch should be called in lyxfunc.C instead of MenuSearch() ?

void MenuSearch()
{
	current_view->getOwner()->getFR()->StartSearch();   
}
