#ifndef _KLYX_H_
#define _KLYX_H_

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "LString.h"

#include <kapp.h>
#include <ktmainwindow.h>

#include <qwidget.h>
#include <qpushbt.h>
#include <qframe.h>


class KToolBarCombo;

class ParagraphDialog;
class ParagraphDialogReceiver;
class LyXView;
class BufferView;
class InsertFigureDialog;
class InsertTableDialog;
class DocumentLayoutDialog;
class DocumentLayoutDialogReceiver;


extern Display* qt_display;

#define k_tlw current_view->getOwner()->toplevelWidget()
#define klyxdialogs current_view->getOwner()->dialogs()
#define layoutcombo current_view->getOwner()->layoutCombo()
#define klyxprinter current_view->getOwner()->klyxPrinter()

/// default character set
#define DEFCHSET_PRIM "iso8859-1"
#define DEFENCODING_PRIM "default"
#define DEFLANG_PRIM "C"
#define DEFLANGUAGE_PRIM "default"

extern LString DEFCHSET_VAR;
extern LString DEFENCODING_VAR;
extern LString DEFLANG_VAR;
extern LString DEFLANGUAGE_VAR;

#define DEFCHSET DEFCHSET_VAR.c_str()
#define DEFENCODING DEFENCODING_VAR.c_str()
#define DEFLANG DEFLANG_VAR.c_str()
#define DEFLANGUAGE DEFLANGUAGE_VAR.c_str()


// delete all toplevel widgets (will destroy lyxviews as well)
extern void deleteAllToplevelWidgets();


class KLyXToplevelWidget : public KTMainWindow
{
  Q_OBJECT
public:
  KLyXToplevelWidget (LyXView* _view,const char* name=0);
  ~KLyXToplevelWidget();

  bool queryExit();

private:
  LyXView* view;
};

class K_Canvas: public QWidget
{
  Q_OBJECT
public:
  K_Canvas (BufferView* _view, QWidget *parent=0, const char* name=0);
  ~K_Canvas();

  QRect *work_area;
  QScrollBar* scrollbar;
  BufferView* view;

  void startUpdateTimer(float timer);
  void stopUpdateTimer();

  void takeFocus();


 public slots:
 void scrollbarChanged(int);
 void updateTimerTimeout();

protected:
  void timerEvent( QTimerEvent * );
  void mousePressEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  void mouseDoubleClickEvent( QMouseEvent * );
  void mouseMoveEvent( QMouseEvent * );
  void keyPressEvent( QKeyEvent * );
  void keyReleaseEvent( QKeyEvent * );
  void focusInEvent( QFocusEvent * );
  void focusOutEvent( QFocusEvent * );
  void enterEvent( QEvent * );
  void leaveEvent( QEvent * );
  void paintEvent( QPaintEvent * );
  void moveEvent( QMoveEvent * );
  void resizeEvent( QResizeEvent * );
 private:
  QTimer *updateTimer;
};


class K_Frame: public QWidget
{
  Q_OBJECT
public:
  K_Frame (QWidget *parent=0, const char* name=0);
  ~K_Frame(){};
  
  void setWidgets(QWidget* _w, QWidget* _s);

  QWidget *w;
  QWidget *s;
  QFrame *f1;
  QFrame *f2;

protected:
  void resizeEvent( QResizeEvent * );
};

class MyApp:public KApplication {
public:
  MyApp( int &argc, char **argv, const QString& rAppName );
  virtual bool x11EventFilter( XEvent * );
};



#endif
