// -*- C++ -*-
/* This file is part of*
 * ======================================================
 *
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1997 Asger Alstrup
 *
 *======================================================*/

#ifndef _INSET_SPECIALCHAR_H
#define _INSET_SPECIALCHAR_H

#include "lyxinset.h"
#include "LString.h"

///  Used to insert special chars
class InsetSpecialChar: public Inset {
public:

	/// The different kinds of special chars we support
	enum Kind {
		/// Optional hyphenation point (\-)
		HYPHENATION,
		/// ... (\ldots)
		LDOTS,
		/// End of sentence punctuation (\@)
		END_OF_SENTENCE
	};

	///
	InsetSpecialChar();
	///
	InsetSpecialChar(Kind k);
	///
	~InsetSpecialChar();
	///
	int Ascent(LyXFont const &font) const;
	///
	int Descent(LyXFont const &font) const;
	///
	int Width(LyXFont const &font) const;
	///
	void Draw(LyXFont, LyXScreen &scr, int baseline, float &x);
	///
	void Write(FILE *file);
	/// Will not be used when lyxf3
	void Read(LyXLex &lex);
	/// 
	int Latex(FILE *file, signed char fragile);
	///
	int Latex(LString &file, signed char fragile);
	///
	Inset* Clone();
	///  
	Inset::Code LyxCode() const
	{
		return Inset::NO_CODE;
	}
	/// We don't need \begin_inset and \end_inset
	bool DirectWrite() const 
	{
		return true;
	};
private:
	/// And which kind is this?
	Kind kind;
};

#endif
