// -*- C++ -*-
/* This file is part of*
 * ======================================================
 *
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *                        1996, 1997 LyX Team
 * 
 *======================================================*/

#ifndef _INSET_LOT_H
#define _INSET_LOT_H

#include <kapp.h>
#include <klocale.h>

#include "insetcommand.h"

// Created by Lgb 970527

/** Used to insert table of contents
 */
class InsetLOT: public InsetCommand {
public:
	///
	InsetLOT(): InsetCommand("listoftables") { }
	///
	InsetLOT(Buffer *b): InsetCommand("listoftables"), owner(b){};
        ///
        Inset* Clone() { return new InsetLOT(owner); }
    	///
	LString getScreenLabel() const { return klocale->translate("List of Tables"); }
        
	//void Edit(int, int);
        ///
	unsigned char Editable() const {
		return NOT_EDITABLE; // not yet
	}
	///
	bool Display() const { return true; }
	///
	Inset::Code LyxCode() const { return Inset::LOT_CODE; }
private:
	///
	Buffer *owner;
};

#endif
