/* This file is part of
 * ======================================================
 *
 *           KLyX, the KDE Document Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *                        1996-1999 LyX and KLyX Team
 * 
 *======================================================*/

#include <config.h>

#include <kapp.h>
#include <klocale.h>

#include <stdlib.h>
#include "insetbib.h"
#include "buffer.h"
#include "error.h"
#include "lyx_gui_misc.h"
#include "BufferView.h"
#include "lyxtext.h"
#include "InsertCitationReferenceDialog.h"
#include "InsertBibitemDialog.h"
#include "LyXView.h"

extern BufferView *current_view;

extern void UpdateInset(Inset* inset, bool mark_dirty = true);

InsetCitation::InsetCitation(LString const & key, LString const & note):
	InsetCommand("cite", key, note)
{

}

void InsetCitation::Edit( int, int )
{
    if(current_view->currentBuffer()->isReadonly())
	WarnReadonly();
  
    if( ! klyxdialogs->insertcitationref )
	klyxdialogs->insertcitationref = new InsertCitationReferenceDialog( current_view->getOwner() );
  
    klyxdialogs->insertcitationref->setInset( this );
    klyxdialogs->insertcitationref->updateBibItems();
    klyxdialogs->insertcitationref->ensureBibItem( getContents().c_str() );
    klyxdialogs->insertcitationref->setRemark( getOptions().c_str() );
    
    (void)klyxdialogs->insertcitationref->exec();
}


LString InsetCitation::getScreenLabel() const
{
    LString temp('[');
    
    if (contents.empty()) {
	temp+="???";
    } else {
	temp+=contents;
    }
    
    if (!options.empty()) {
	temp+=","+options;
    }

    return temp+']';
}


InsetBibKey::InsetBibKey(LString const & key, LString const & label)
    : InsetCommand("bibitem", key, label)
{
	counter = 1;
	if (key.empty())
		contents = ' ';
}


InsetBibKey::InsetBibKey(InsetBibKey const *b):
	InsetCommand("bibitem", b->contents, b->options)
{
	counter = b->counter;
}


void InsetBibKey::setCounter(int c) 
{ 
	counter = c; 
    
	if (contents.empty())
		contents += counter;
}


// I'm sorry but this is still necessary because \bibitem is used also
// as a LyX 2.x command, and lyxlex is not enough smart to understand
// real LaTeX commands. Yes, that could be fixed, but would be a waste 
// of time cause LyX3 won't use lyxlex anyway.  (ale)
void InsetBibKey::Write(FILE *file)
{
	LString s;
	if (!options.empty()) {
		s += '[';
		s += options + ']';
	}
	s += '{';
	s += contents + '}';
	fprintf(file,"\\bibitem %s\n", s.c_str());
}


LString InsetBibKey::getScreenLabel() const
{
	if (!options.empty())
		return options;
    
	LString s;
	return s + counter;
}


void InsetBibKey::Edit(int, int)
{
  if( current_view->currentBuffer()->isReadonly() )
	WarnReadonly();
	
  if( !klyxdialogs->bibitem )
	klyxdialogs->bibitem = new InsertBibitemDialog( current_view->getOwner() );
  
  klyxdialogs->bibitem->setInset( this );
  klyxdialogs->bibitem->setFirstLabel( i18n( "Key:" ) );
  klyxdialogs->bibitem->setSecondLabel( i18n( "Label:" ) );
  klyxdialogs->bibitem->setFirstEdit( getContents().c_str() );
  klyxdialogs->bibitem->setSecondEdit( getOptions().c_str() );

  (void)klyxdialogs->bibitem->exec();
}



InsetBibtex::InsetBibtex( LString const& dbase, LString const& style, Buffer *o)
    : InsetCommand("BibTeX", dbase, style), owner(o)
{
}


InsetBibtex::~InsetBibtex()
{
}


LString InsetBibtex::getScreenLabel() const
{
  return i18n("BibTeX Generated References");
}


int InsetBibtex::Latex(FILE *file, signed char /*fragile*/)
{
  LString bib;
  signed char dummy = 0;
  int result = Latex(bib, dummy);
  fprintf(file, "%s", bib.c_str());
  return result;
}


int InsetBibtex::Latex(LString &file, signed char /*fragile*/)
{
  file += "\\bibliographystyle{";
  file += getOptions();
  file += "}\n";
  file += "\\bibliography{";
  file += getContents();
  file += "}\n";
  return 2;
}


// BibTeX should have its own dialog. This is provisional.
void InsetBibtex::Edit(int, int)
{
  if( !klyxdialogs->bibitem )
	klyxdialogs->bibitem = new InsertBibitemDialog( current_view->getOwner() );
  
  klyxdialogs->bibitem->setInset( this );
  klyxdialogs->bibitem->setFirstLabel( i18n( "Database:" ) );
  klyxdialogs->bibitem->setSecondLabel( i18n( "Style:" ) );
  klyxdialogs->bibitem->setFirstEdit( getContents().c_str() );
  klyxdialogs->bibitem->setSecondEdit( getOptions().c_str() );

  (void)klyxdialogs->bibitem->exec();
}


bool InsetBibtex::addDatabase(LString const &db)
{
  if (!contents.contains(db.c_str())) {
	if (!contents.empty()) 
	  contents += ',';
	contents += db;
	return true;
  }
  return false;
}


bool InsetBibtex::delDatabase(LString const &db)
{
  if (contents.contains(db.c_str())) {
	LString bd = db;
	int n = contents.tokenPos(',', bd);
	if (n > 0) {
	  LString tmp(',');
	  tmp += bd;
	  contents.subst(tmp.c_str(), ",");
	} else if (n==0)
	  contents.split(bd, ',');
	else 
	  return false;
  }
  return true;
}


// ale070405 This function maybe shouldn't be here. We'll fix this at 0.13.
int bibitemMaxWidth(const class LyXFont &font)
{
  int w = 0;
  // Does look like a hack? It is! (but will change at 0.13)
  LyXParagraph *par = current_view->currentBuffer()->paragraph;
  
  while (par) {
	if (par->bibkey) {
	  int wx = par->bibkey->Width(font);
	  if (wx>w) w = wx;
	}
	par = par->next;
  }
  return w;
}


// ale070405 
LString bibitemWidthest()
{
  int w = 0;
  // Does look like a hack? It is! (but will change at 0.13)
  LyXParagraph *par = current_view->currentBuffer()->paragraph;
  InsetBibKey *bkey=0;
  LyXFont font;
  
  while (par) {
	if (par->bibkey) {
	  int wx = par->bibkey->Width(font);
	  if (wx>w) {
		w = wx;
		bkey = par->bibkey;
	  }
	}
	par = par->next;
  }
  
  if (bkey)
	return bkey->getOptions();
  
  return LString();
}


// Local Variables:
// mode: C++
// c-file-style: "Stroustrup"
// End:
