/*
 * $Id: VCLogDialog.C,v 1.5 1999/01/05 11:16:57 kulow Exp $
 */

#include "VCLogDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qfileinf.h>
#include <qmlined.h>
#include <qpushbt.h>
#include <qlayout.h>

#include "LyXView.h"

VCLogDialog::VCLogDialog( LyXView* view, QWidget * parent=0, 
						  const char * name=0, 
						  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  editED = new QMultiLineEdit( this );

  QPushButton* updatePB = new QPushButton( i18n( "&Update" ), 
										   this );
  QObject::connect( updatePB, SIGNAL( clicked() ),
					this, SLOT( updateClicked() ) );

  QPushButton* closePB = new QPushButton( i18n( "&Close" ), 
										  this );
  QObject::connect( closePB, SIGNAL( clicked() ),
					this, SLOT( closeClicked() ) );

  setCaption( i18n( "VC Log" ) );

  updatePB->setMinimumSize(updatePB->sizeHint());
  closePB->setMinimumSize(closePB->sizeHint());
  if (updatePB->minimumSize().width() <75)
      updatePB->setFixedWidth(75);
  if (closePB->minimumSize().width() <75)
      closePB->setFixedWidth(75);
  
  QVBoxLayout *v=new QVBoxLayout(this,5,5);
  QHBoxLayout *h=new QHBoxLayout();
  v->addWidget(editED,1);
  v->addLayout(h,0);
  h->addWidget(updatePB,0);
  h->addStretch(10);
  h->addWidget(closePB,0);
  v->activate();

  resize(400,400);
  


}


void VCLogDialog::updateClicked()
{
}


void VCLogDialog::closeClicked()
{
  reject();
}


void VCLogDialog::loadFile( const char* filename )
{
  logfile = filename;

  editED->clear();

  if( !QFileInfo( filename ).exists() )
	editED->insertLine( i18n( "No RCS History!" ) );
  else
	{
	  QFile file( filename );
	  if( file.open( IO_ReadOnly ) )
		{
		  QTextStream stream( &file );
		  while( !stream.eof() )
			editED->insertLine( stream.readLine() );
		  
		  file.close();
		}
	}
}


/*
 * $Log: VCLogDialog.C,v $
 * Revision 1.5  1999/01/05 11:16:57  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.4  1998/03/05 20:39:23  ralsina
 * [Roberto] GMified VCLogDialog
 *
 * Revision 1.3  1998/03/04 21:49:55  kalle
 * More Qt-ified
 *
 * Revision 1.2  1998/03/03 22:36:29  kulow
 * removed all those ->show(), they make me crazy
 *
 * Revision 1.1  1998/02/16 20:21:11  kalle
 * Kalle: First XForms-free version
 *
 */
