/*
 * $Id: ParagraphExtraDialog.C,v 1.8 1999/01/05 11:16:46 kulow Exp $
 */

#include "ParagraphExtraDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qmsgbox.h>
#include <qpushbt.h>
#include <qradiobt.h>

#include "lyxparagraph.h"
#include "lyxtext.h"
#include "BufferView.h"
#include "minibuffer.h"
#include "buffer.h"

#include <stdlib.h>

extern BufferView* current_view;

ParagraphExtraDialog::ParagraphExtraDialog( QWidget * parent=0, 
											const char * name=0, 
											WFlags f=0 ) :
  QDialog( parent, name, true, f )
{
  extraoptionsBG = new QButtonGroup( i18n( "Extra Options" ), this );
  extraoptionsBG->setGeometry( 10, 10, 150, 120 );

  indentedparagraphRB = new QRadioButton( i18n( "&Indented Paragraph" ), this );
  indentedparagraphRB->setGeometry( 20, 30, 135, 30 );
  extraoptionsBG->insert( indentedparagraphRB );
  QObject::connect( indentedparagraphRB, SIGNAL( toggled( bool ) ),
					this, SLOT( indentToggled( bool ) ) );

  minipageRB = new QRadioButton( i18n( "&Minipage" ), this );
  minipageRB->setGeometry( 20, 60, 100, 30 );
  QObject::connect( minipageRB, SIGNAL( toggled( bool ) ),
					this, SLOT( minipageToggled( bool ) ) );
  extraoptionsBG->insert( minipageRB );

  floatfltRB = new QRadioButton( i18n( "&Floatflt" ), this );
  floatfltRB->setGeometry( 20, 90, 100, 30 );
  QObject::connect( floatfltRB, SIGNAL( toggled( bool ) ),
					this, SLOT( floatfltToggled( bool ) ) );
  extraoptionsBG->insert( floatfltRB );


  widthGB = new QGroupBox( i18n( "Width" ), this );
  widthGB->setGeometry( 170, 10, 170, 120 );

  lengthLA = new QLabel( i18n( "Length" ), this );
  lengthLA->setGeometry( 180, 35, 40, 30 );
  lengthLA->setAlignment( AlignRight );

  lengthED = new QLineEdit( this );
  lengthED->setGeometry( 230, 30, 100, 30 );
  
  percentLA = new QLabel( i18n( "or %" ), this );
  percentLA->setGeometry( 180, 75, 40, 30 );
  percentLA->setAlignment( AlignRight );

  percentED = new QLineEdit( this );
  percentED->setGeometry( 230, 70, 100, 30 );


  alignmentBG = new QButtonGroup( i18n( "Alignment" ), this );
  alignmentBG->setGeometry( 350, 10, 110, 120 );

  topRB = new QRadioButton( i18n( "Top" ), this );
  topRB->setGeometry( 360, 30, 70, 30 );
  alignmentBG->insert( topRB );

  middleRB = new QRadioButton( i18n( "Middle" ), this );
  middleRB->setGeometry( 360, 60, 70, 30 );
  alignmentBG->insert( middleRB );

  bottomRB = new QRadioButton( i18n( "Bottom" ), this );
  bottomRB->setGeometry( 360, 90, 70, 30 );
  alignmentBG->insert( bottomRB );


  hfillminipageCB = new QCheckBox( i18n( "HFill between Minipage paragraphs" ), this );
  hfillminipageCB->setGeometry( 50, 145, 270, 30 );

  startminipageCB = new QCheckBox( i18n( "Start new Minipage" ), this );
  startminipageCB->setGeometry( 50, 175, 240, 30 );


  okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 190, 220, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL(clicked()), SLOT(accept()) );

  cancelPB = new QPushButton( i18n( "Cancel" ), this );
  cancelPB->setGeometry( 310, 220, 100, 30 );
  connect( cancelPB, SIGNAL(clicked()), SLOT(reject()) );

  setCaption( i18n( "ParagraphExtra Layout" ) );
}


void ParagraphExtraDialog::setData( ParagraphExtraDialogData* data )
{
  if( data )
	{
	  switch( data->extra_options )
		{
		case ParagraphExtraDialogData::IndentedParagraph:
		  indentedparagraphRB->setChecked( true );
		  break;
		case ParagraphExtraDialogData::Minipage:
		  minipageRB->setChecked( true );
		  break;
		case ParagraphExtraDialogData::Floatflt:
		  floatfltRB->setChecked( true );
		  break;
		};
	  
	  lengthED->setText( data->length );
	  percentED->setText( data->percent );
	  
	  switch( data->alignment )
		{
		case ParagraphExtraDialogData::Top:
		  topRB->setChecked( true );
		  break;
		case ParagraphExtraDialogData::Middle:
		  middleRB->setChecked( true );
		  break;
		case ParagraphExtraDialogData::Bottom:
		  bottomRB->setChecked( true );
		  break;
		};
	  
	  hfillminipageCB->setChecked( data->hfill_between_minipages );
	  startminipageCB->setChecked( data->start_new_minipage );
	}
}


static ParagraphExtraDialogData tempdata;

ParagraphExtraDialogData* ParagraphExtraDialog::data() const
{
  if( indentedparagraphRB->isChecked() )
	tempdata.extra_options = ParagraphExtraDialogData::IndentedParagraph;
  else if( indentedparagraphRB->isChecked() )
	tempdata.extra_options = ParagraphExtraDialogData::Minipage;
  else if( floatfltRB->isChecked() )
	tempdata.extra_options = ParagraphExtraDialogData::Floatflt;
  else
	lyxerr_debug( "Could determine value for ParagraphExtraDialogData::extra_options" );

  tempdata.length = lengthED->text();
  tempdata.percent = percentED->text();
  
  if( topRB->isChecked() )
	tempdata.alignment = ParagraphExtraDialogData::Top;
  else if( middleRB->isChecked() )
	tempdata.alignment = ParagraphExtraDialogData::Middle;
  else if( bottomRB->isChecked() )
	tempdata.alignment = ParagraphExtraDialogData::Bottom;
  else
	lyxerr_debug( "Could not determine value for ParagraphExtraDialogData::alignment" );

  tempdata.hfill_between_minipages = hfillminipageCB->isChecked();
  tempdata.start_new_minipage = startminipageCB->isChecked();

  return &tempdata;
}


void ParagraphExtraDialog::deactivateButtons()
{
  okPB->setEnabled( false );
}


void ParagraphExtraDialog::activateButtons()
{
  okPB->setEnabled( true );
}


void ParagraphExtraDialog::disable()
{
  deactivateButtons();

  extraoptionsBG->setEnabled( false );
  indentedparagraphRB->setEnabled( false );
  floatfltRB->setEnabled( false );
  minipageRB->setEnabled( false );
  widthGB->setEnabled( false );
  lengthED->setEnabled( false );
  percentED->setEnabled( false );
  alignmentBG->setEnabled( false );
  topRB->setEnabled( false );
  middleRB->setEnabled( false );
  bottomRB->setEnabled( false );
  hfillminipageCB->setEnabled( false );
  startminipageCB->setEnabled( false );
}


void ParagraphExtraDialog::enable()
{
  activateButtons();

  extraoptionsBG->setEnabled( true );
  indentedparagraphRB->setEnabled( true );
  floatfltRB->setEnabled( true );
  minipageRB->setEnabled( true );
  widthGB->setEnabled( true );
  lengthED->setEnabled( true );
  percentED->setEnabled( true );
  alignmentBG->setEnabled( true );
  topRB->setEnabled( true );
  middleRB->setEnabled( true );
  bottomRB->setEnabled( true );
  hfillminipageCB->setEnabled( true );
  startminipageCB->setEnabled( true );
}


void ParagraphExtraDialog::updateData()
{
  bool update = false;
  if( current_view->getScreen() && current_view->available() ) {
	update = true;
	LyXParagraph* par = current_view->currentBuffer()->text->cursor.par;
	
	enable();

	lengthED->setText( par->pextra_width.c_str() );
	percentED->setText( par->pextra_widthp.c_str() );

	switch( par->pextra_alignment ) {
	case MINIPAGE_ALIGN_TOP:
	  topRB->setChecked( true );
	  break;
	case MINIPAGE_ALIGN_MIDDLE:
	  middleRB->setChecked( true );
	  break;
	case MINIPAGE_ALIGN_BOTTOM:
	  bottomRB->setChecked( true );
	  break;
	}

	hfillminipageCB->setChecked( par->pextra_hfill );
	startminipageCB->setChecked( par->pextra_start_minipage );
	checkInputWidth();

	if( par->pextra_type == PEXTRA_INDENT ) {
	  indentedparagraphRB->setChecked( true );
	  minipageRB->setChecked( false );
	  floatfltRB->setChecked( false );
	  topRB->setEnabled( false );
	  middleRB->setEnabled( false );
	  bottomRB->setEnabled( false );
	} else if( par->pextra_type == PEXTRA_MINIPAGE ) {
	  minipageRB->setChecked( true );
	  indentedparagraphRB->setChecked( false );
	  floatfltRB->setChecked( false );
	  topRB->setEnabled( true );
	  middleRB->setEnabled( true );
	  bottomRB->setEnabled( true );
	} else if( par->pextra_type == PEXTRA_FLOATFLT ) {
	  floatfltRB->setChecked( true );
	  minipageRB->setChecked( false );
	  indentedparagraphRB->setChecked( false );
	  topRB->setEnabled( false );
	  middleRB->setEnabled( false );
	  bottomRB->setEnabled( false );
	} else {
	  indentedparagraphRB->setChecked( false );
	  minipageRB->setChecked( false );
	  lengthED->setEnabled( false );
	  percentED->setEnabled( false );
	  topRB->setEnabled( false );
	  middleRB->setEnabled( false );
	  bottomRB->setEnabled( false );
	}
	if (par->pextra_type == PEXTRA_NONE )
	  activateButtons();
  }

  if (current_view->currentBuffer()->isReadonly()) {
	disable();
	QMessageBox::information( this, i18n( "Read-only buffer" ), 
							  i18n( "Buffer is read-only.  No changes to layout permitted."),
							  i18n( "OK" ) );
  }
}


void ParagraphExtraDialog::applyData()
{
  if (current_view->getScreen() && current_view->available()) {
	const char
	  *width = lengthED->text(),
	  *widthp = percentED->text();
	LyXText
	  *text = current_view->currentBuffer()->text;
	int
	  type = PEXTRA_NONE,
	  alignment = 0;
	bool
	  hfill = false,
	  start_minipage = false;
	
	if( indentedparagraphRB->isChecked() ) {
	  type = PEXTRA_INDENT;
	} else if ( minipageRB->isChecked() ) {
	  type = PEXTRA_MINIPAGE;
	  hfill = hfillminipageCB->isChecked();
	  start_minipage = startminipageCB->isChecked();
	  if( topRB->isChecked() )
		alignment = MINIPAGE_ALIGN_TOP;
	  else if ( middleRB->isChecked() )
		alignment = MINIPAGE_ALIGN_MIDDLE;
	  else if( bottomRB->isChecked() )
		alignment = MINIPAGE_ALIGN_BOTTOM;
	}
	else if( floatfltRB->isChecked() )
	  {
		type = PEXTRA_FLOATFLT;
	  }
	text->SetParagraphExtraOpt( type,width,widthp,alignment,hfill,
								start_minipage );
	//        current_view->redoCurrentBuffer();
	current_view->currentBuffer()->updateFull();
	current_view->getMiniBuffer()->Set( i18n("ParagraphExtra layout set") );
	//	current_view->currentBuffer()->markDirty();
  }
  return;
}


bool ParagraphExtraDialog::checkInputWidth()
{
  LString s1,s2;

  s1 = lengthED->text();
  s2 = percentED->text();
  if (s1.empty() && s2.empty()) {
	lengthED->setEnabled( true );
	percentED->setEnabled( true );
	deactivateButtons();
	return false;
  }
  if (!s1.empty()) { // LyXLength parameter
	lengthED->setEnabled( true );
	percentED->setEnabled( false );
	if( !isValidLength( s1 ) ) {
	  deactivateButtons();
	  QMessageBox::warning( this, i18n( "Invalid Length" ),
							i18n( "Warning: Invalid Length (valid example: 10mm)" ) );
	  return false;
	}
  } else { // !s2.empty() % parameter
	lengthED->setEnabled( false );
	percentED->setEnabled( true );
	if ((atoi(s2.c_str()) < 0 ) || (atoi(s2.c_str()) > 100)) {
	  deactivateButtons();
	  QMessageBox::warning( this, i18n( "Invalid Value" ),
							i18n("Warning: Invalid percent value (0-100)" ) );
	  return false;
	}
  }
  return true;
}


void ParagraphExtraDialog::indentToggled( bool on )
{
  activateButtons();
  checkInputWidth();

  if( on )
	{
	  lengthED->setEnabled( true );
	  percentED->setEnabled( true );
	  topRB->setEnabled( false );
	  middleRB->setEnabled( false );
	  bottomRB->setEnabled( false );
	}
  else
	{
	  lengthED->setEnabled( false );
	  percentED->setEnabled( false );
	  activateButtons();
	}
}


void ParagraphExtraDialog::minipageToggled( bool on )
{
  activateButtons();
  checkInputWidth();

  if( on )
	{
	  lengthED->setEnabled( true );
	  percentED->setEnabled( true );
	  topRB->setEnabled( true );
	  middleRB->setEnabled( true );
	  bottomRB->setEnabled( true );
	}
  else
	{
	  lengthED->setEnabled( false );
	  percentED->setEnabled( false );
	  topRB->setEnabled( false );
	  middleRB->setEnabled( false );
	  bottomRB->setEnabled( false );
	  activateButtons();
	}
}


void ParagraphExtraDialog::floatfltToggled( bool on )
{
  activateButtons();
  checkInputWidth();

  if( on )
	{
	  lengthED->setEnabled( true );
	  percentED->setEnabled( true );
	  topRB->setEnabled( true );
	  middleRB->setEnabled( true );
	  bottomRB->setEnabled( true );
	}
  else
	{
	  lengthED->setEnabled( false );
	  percentED->setEnabled( false );
	  topRB->setEnabled( false );
	  middleRB->setEnabled( false );
	  bottomRB->setEnabled( false );
	  activateButtons();
	}
}


/*
 * $Log: ParagraphExtraDialog.C,v $
 * Revision 1.8  1999/01/05 11:16:46  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.7  1998/05/17 15:58:01  schreter
 *
 *
 * Changed label widths to fit in Slovak translations (mainly).
 * Also added character set autodetection (from /opt/kderc, General Font,
 * Charset). It only accepts iso8859-1,2,7, since only these do have
 * .cdef files for them. Use DEFCHARSET (defined in klyx.h) for defaults
 * in config reads, etc. I've changed string "iso8859-1" to DEFCHARSET
 * where appropriate.
 * TODO: fix autodetection, use some locale functions instead of kderc.
 *
 * Revision 1.6  1998/03/17 15:56:34  ettrich
 * Matthias: fixed half a million of bugs
 *
 * Revision 1.5  1998/03/04 21:49:35  kalle
 * More Qt-ified
 *
 * Revision 1.4  1998/02/28 18:01:32  kalle
 * Kalle: Made ParagraphExtraDialog work and added Floatflt button
 *
 * Revision 1.3  1998/02/16 20:21:07  kalle
 * Kalle: First XForms-free version
 *
 * Revision 1.2  1998/01/28 22:44:20  kalle
 * activated new ParagraphExtraDialog (still buggy, and I don't understand
 * the options anyway :-))
 * 1626 XForms calls left (this was a good one)
 * fixed a bug in the document layout dialog
 *
 * Revision 1.1.1.1  1997/12/14 21:19:34  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.1  1997/11/26 16:11:15  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.2  1997/11/16 22:07:29  kalle
 * added CharacterStyleDialog
 *
 * Revision 1.1  1997/11/15 22:11:54  kalle
 * ParagraphExtraDialog added
 *
 *
 */
