/*
 * $Id: ParagraphDialog.h,v 1.3 1998/03/12 15:32:20 ettrich Exp $
 */

#ifndef _PARAGRAPHDIALOG_H
#define _PARAGRAPHDIALOG_H

#include <qdialog.h>
#include <qstring.h>

#include "lyxdummies.h"

class QButtonGroup;
class QCheckBox;
class QComboBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;

class ParagraphExtraDialogData;

struct ParagraphDialogData
{
  enum Alignment { Right, Left, Block, Center };
  Alignment alignment;
  bool lines_above;
  bool lines_below;
  bool pagebreaks_above;
  bool pagebreaks_below;
  enum VerticalSpaces { VS_None, VS_Defskip, VS_Smallskip, VS_Medskip, 
			VS_Bigskip, VS_Vfill, VS_Length };
  VerticalSpaces vertical_spaces_above;
  VerticalSpaces vertical_spaces_below;
  QString space_above;
  QString space_below;
  bool space_keep_above;
  bool space_keep_below;
  bool noindent;
  enum Spacing { Single, Onehalf, Double, Other, LayoutDefault };
  Spacing spacing;
  QString spacing_length;
  QString label_width;
};


class ParagraphDialog : public QDialog
{
friend class ParagraphDialogReceiver;

  Q_OBJECT

public:
  ParagraphDialog ( QWidget * parent=0, const char * name=0, 
							  WFlags f=0 ) ;
  ~ParagraphDialog();
  void setData( ParagraphDialogData* data );
  ParagraphDialogData* data() const;
  void setExtraData( ParagraphExtraDialogData* data ) { _extra_data = data; }
  ParagraphExtraDialogData* extra_data() const { return _extra_data; }

  void activate();
  void deactivate();
  
signals:
  void apply();

private slots:
  void applyClicked();
  void spacingTextChanged( const char* text );
  void showExtraOptionsDialog();

private:
  QButtonGroup* alignmentBG;
  QGroupBox* verticalspacesGB;
  QButtonGroup* pagebreaksBG;
  QButtonGroup* linesBG;
  QButtonGroup* indentBG;
  QRadioButton* rightRB;
  QRadioButton* leftRB;
  QRadioButton* blockRB;
  QRadioButton* centerRB;
  QCheckBox* abovelinesCB;
  QCheckBox* belowlinesCB;
  QCheckBox* abovepagebreakCB;
  QCheckBox* belowpagebreakCB;
  QComboBox* abovespaceCO;
  QComboBox* belowspaceCO;
  QLabel* abovespaceLA;
  QLabel* belowspaceLA;
  QLineEdit* abovespaceED;
  QLineEdit* belowspaceED;
  QCheckBox* abovespacekeepCB;
  QCheckBox* belowspacekeepCB;
  QCheckBox* noindentCB;
  QComboBox* spacingCO;
  QLineEdit* spacingED;
  QLineEdit* labelwidthED;
  QLabel* labelwidthLA;
  QPushButton* extraoptPB;
  QPushButton* okPB;
  QPushButton* applyPB;
  QPushButton* cancelPB;

  ParagraphExtraDialogData* _extra_data;
};

class ParagraphDialogReceiver : public QObject
{
friend class ParagraphDialog;

  Q_OBJECT

public:
  ParagraphDialogReceiver( ParagraphDialog* );
  ~ParagraphDialogReceiver();  

private slots:
  void apply();
  void comboSpaceAbove( int );
  void comboSpaceBelow( int );
  void editSpaceAbove( const char* );
  void editSpaceBelow( const char* );
  void comboSpacing( int );
  void editSpacing( const char* );

private:
  ParagraphDialog* _dlg;
};


#endif

/*
 * $Log: ParagraphDialog.h,v $
 * Revision 1.3  1998/03/12 15:32:20  ettrich
 * Matthias:
 *
 *       spacing for paragraphs, bugfixes, cleanups
 *
 * Revision 1.2  1998/03/09 22:06:06  kalle
 * Towards 0.8.4...
 *
 * Loads of fixes and changes:
 * - added KFileDialog. --enable-kfiledialog uses it, otherwise QFileDialog is used
 * - font loading now faster and more robust
 * - prepared ParagraphDialog for line skips per paragraph (some code from Matthias is still missing)
 * - Changed the way the menus are created
 *
 * KLyX NOW REQUIRES QT 1.32!!!
 *
 * Revision 1.1.1.1  1997/12/14 21:19:34  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.3  1997/11/27 08:56:34  kalle
 * ParagraphDialog works
 *
 * Revision 1.2  1997/11/26 19:22:20  kalle
 * First KDE dialog visible
 *
 * Revision 1.1  1997/11/26 16:11:15  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.2  1997/11/15 22:11:54  kalle
 * ParagraphExtraDialog added
 *
 * Revision 1.1  1997/11/15 20:51:49  kalle
 * ParagraphDialog added
 *
 */
