/*
 * $Id: MathSpacingDialog.h,v 1.2 1998/03/11 19:12:03 kalle Exp $
 */

#ifndef _MATHSPACINGDIALOG_H
#define _MATHSPACINGDIALOG_H

#include <qdialog.h>

class QRadioButton;

class LyXView;

#define MATHSPACING_THIN 0
#define MATHSPACING_MEDIUM 1
#define MATHSPACING_THICK 2
#define MATHSPACING_NEGATIVE 3
#define MATHSPACING_SQUAREINCH 4
#define MATHSPACING_TWOSQUAREINCHES 5

class MathSpacingDialog : public QDialog
{
  Q_OBJECT

public:
  MathSpacingDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
					  WFlags f=0 );

  void setSpacing( int );
  int spacing() const;

private slots:
  void applyClicked();
  void okClicked();
  void cancelClicked();

private:
  LyXView* _view;

  QRadioButton* thinRB;
  QRadioButton* mediumRB;
  QRadioButton* thickRB;
  QRadioButton* negativeRB;
  QRadioButton* squareinchRB;
  QRadioButton* twosquareinchesRB;
};

#endif

/*
 * $Log: MathSpacingDialog.h,v $
 * Revision 1.2  1998/03/11 19:12:03  kalle
 * More dialogs Qt-ified
 *
 * Revision 1.1  1998/01/09 19:51:12  kalle
 * Math matrix and math spacing dialogs added
 *
 */
