/*
 * $Id: MathDelimiterDialog.h,v 1.3 1998/06/08 21:40:07 kalle Exp $
 */

#ifndef _MATHDELIMITERDIALOG_H
#define _MATHDELIMITERDIALOG_H

#include <qdialog.h>

class QLabel;
class QPushButton;
class QRadioButton;
class KIconLoader;

class LyXView;

class MathDelimiterDialog : public QDialog
{
  Q_OBJECT

public:
  MathDelimiterDialog ( LyXView* view, QWidget * parent=0, 
						const char * name=0, WFlags f=0 );

signals:
  void apply();
  void ok();
  void cancel();

private slots:
  void applyClicked();
  void okClicked();
  void cancelClicked();
  void lparenClicked();
  void rparenClicked();
  void lceilClicked();
  void rceilClicked();
  void uparrowClicked();
  void UparrowClicked();
  void lsqbClicked();
  void rsqbClicked();
  void lfloorClicked();
  void rfloorClicked();
  void updownarrowClicked();
  void UpdownarrowClicked();
  void lcubClicked();
  void rcubClicked();
  void solClicked();
  void bsolClicked();
  void downarrowClicked();
  void DownarrowClicked();
  void langleClicked();
  void rangleClicked();
  void verbarClicked();
  void dverbarClicked();
  void blankClicked();

private:
  int leftDelimiter();
  int rightDelimiter();
  void drawSymbol();

  LyXView* _view;

  QRadioButton* leftRB;
  QRadioButton* rightRB;

  QPushButton* lparenPB;
  QPushButton* rparenPB;
  QPushButton* lceilPB;
  QPushButton* rceilPB;
  QPushButton* uparrowPB;
  QPushButton* UparrowPB;
  QPushButton* lsqbPB;
  QPushButton* rsqbPB;
  QPushButton* lfloorPB;
  QPushButton* rfloorPB;
  QPushButton* updownarrowPB;
  QPushButton* UpdownarrowPB;
  QPushButton* lcubPB;
  QPushButton* rcubPB;
  QPushButton* solPB;
  QPushButton* bsolPB;
  QPushButton* downarrowPB;
  QPushButton* DownarrowPB;
  QPushButton* langlePB;
  QPushButton* ranglePB;
  QPushButton* verbarPB;
  QPushButton* dverbarPB;
  QPushButton* blankPB;

  QLabel* previewLeftLA;
  QLabel* previewRightLA;

  KIconLoader* loader;
  int left, right;
};


#endif

/*
 * $Log: MathDelimiterDialog.h,v $
 * Revision 1.3  1998/06/08 21:40:07  kalle
 * Fixing bugs by the pound:
 * - corrected brelsubseteq.xbm
 * - math delimiter dialog shows delimiters correctly when called the second time
 * - corrected signal connection in paper format dialog
 * - added switch --no-splash for avoiding the splash screen
 *
 * Revision 1.2  1998/03/11 19:11:59  kalle
 * More dialogs Qt-ified
 *
 * Revision 1.1  1998/01/09 22:46:58  kalle
 * math toolbar finished
 * old math panel removed
 * This concludes my work on the math toolbar!
 *
 */
