/*
 * $Id: InsertInfoDialog.C,v 1.5 1999/01/05 11:16:32 kulow Exp $
 */

#include "InsertInfoDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qmlined.h>
#include <qpushbt.h>

InsertInfoDialog::InsertInfoDialog( LyXView* view, QWidget * parent=0,
									  const char * name=0,
									  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  contentsML = new QMultiLineEdit( this );
  contentsML->setGeometry( 10, 10, 380, 120 );

  QPushButton* closePB = new QPushButton( i18n( "Close" ),
										  this );
  closePB->setGeometry( 130, 140, 120, 30 );
  closePB->setDefault( true );
  connect( closePB, SIGNAL( clicked() ), SLOT( closeClicked() ) );

  setCaption( i18n( "Note" ) );
}


void InsertInfoDialog::closeClicked()
{
  accept();
}


void InsertInfoDialog::setContents( const char* text )
{
  contentsML->setText( text );
}

const char* InsertInfoDialog::contents()
{
    return qstrdup(contentsML->text());
}


/*
 * $Log: InsertInfoDialog.C,v $
 * Revision 1.5  1999/01/05 11:16:32  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.4  1998/09/05 16:30:26  ettrich
 * Matthias: info insets fixed.... was broken, sorry
 *
 * Revision 1.3  1998/07/02 18:22:52  ettrich
 * Matthias: made Notes editable as they should be
 *
 * Revision 1.2  1998/03/02 21:13:47  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.1  1998/02/16 20:20:57  kalle
 * Kalle: First XForms-free version
 *
 */
