/*
 * $Id: InsertIncludeDialog.C,v 1.8 1999/01/06 13:32:15 kulow Exp $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kfiledialog.h>

#include "InsertIncludeDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlayout.h>

#include "BufferView.h"
#include "insetinclude.h"
#include "LyXView.h"
#include "lyxfunc.h"
#include "commandtags.h"
#include "filetools.h"
#include "LString.h"

extern void UpdateInset(Inset* inset, bool mark_dirty = true);
extern BufferView* current_view;

InsertIncludeDialog::InsertIncludeDialog( LyXView* view, QWidget * parent=0,
					  const char * name=0,
					  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  // top level layout
  QVBoxLayout *vlayout1 = new QVBoxLayout(this, 10);
  // file name layout
  QGridLayout *grid1 = new QGridLayout(2, 2);
  // layout for the middle part
  QHBoxLayout *hlayout1 = new QHBoxLayout(5);
  // layout for the buttons
  QHBoxLayout *hlayout2 = new QHBoxLayout(3);

  vlayout1->addLayout(grid1, 1);
  vlayout1->addLayout(hlayout1, 6);
  vlayout1->addLayout(hlayout2, 1);

  grid1->setColStretch(0, 4);
  grid1->setColStretch(1, 3);

  QLabel* filenameLA = new QLabel( i18n( "Filename: "), this );
  filenameLA->adjustSize();
  filenameLA->setFixedHeight(filenameLA->height());
  filenameLA->setMinimumWidth(filenameLA->width());

  grid1->addWidget(filenameLA, 0, 0);
  filenameLA->setAlignment( AlignVCenter );

  filenameED = new QLineEdit( this );
  filenameED->adjustSize();
  filenameED->setFixedHeight(filenameED->height());
  filenameED->setMinimumWidth(filenameED->width());
  grid1->addWidget(filenameED, 1, 0);

  QPushButton* filenamePB = new QPushButton( i18n( "&Browse" ), this);
  filenamePB->adjustSize();
  // line edit will force size!!
  filenamePB->setMinimumWidth(filenamePB->width());
  grid1->addWidget(filenamePB, 1, 1);
  connect( filenamePB, SIGNAL( clicked() ), this, SLOT( browseClicked() ) );

  QButtonGroup* styleBG = new QButtonGroup( this );
  QVBoxLayout *vlayout2 = new QVBoxLayout(styleBG, 10, 3);
  connect( styleBG, SIGNAL( clicked( int ) ),
	   this, SLOT( styleGroupClicked( int ) ) );

  includeRB = new QRadioButton( i18n( "&Use include" ), styleBG );
  includeRB->adjustSize();
  includeRB->setMinimumSize(includeRB->size());
  vlayout2->addWidget(includeRB);
  includeRB->setChecked( true );

  inputRB = new QRadioButton( i18n( "Use &input" ), styleBG );
  inputRB->adjustSize();
  inputRB->setMinimumSize(inputRB->size());
  vlayout2->addWidget(inputRB);

  verbatimRB = new QRadioButton( i18n( "&Verbatim" ), styleBG );
  verbatimRB->adjustSize();
  verbatimRB->setMinimumSize(verbatimRB->size());
  vlayout2->addWidget(verbatimRB);
  vlayout2->activate();

  QVBoxLayout *vlayout3 = new QVBoxLayout(3);
  hlayout1->addWidget(styleBG, 2);
  hlayout1->addLayout(vlayout3, 3);

  donttypesetCB = new QCheckBox( i18n( "&Don't typeset" ), this);
  donttypesetCB->adjustSize();
  donttypesetCB->setMinimumSize(donttypesetCB->size());
  vlayout3->addStretch(2);
  vlayout3->addWidget(donttypesetCB, 1);

  visiblespaceCB = new QCheckBox( i18n( "Vi&sible space" ),this);
  visiblespaceCB->adjustSize();
  visiblespaceCB->setMinimumSize(visiblespaceCB->size());
  vlayout3->addWidget(visiblespaceCB, 1);
  visiblespaceCB->setEnabled( false );


  QPushButton* loadPB = new QPushButton( i18n( "&Load" ), this );
  loadPB->adjustSize();
  loadPB->setMinimumSize(loadPB->size());
  loadPB->setMaximumHeight(loadPB->height());
  vlayout3->addStretch(2);
  vlayout3->addWidget(loadPB, 1);
  vlayout3->addStretch(1);
  connect( loadPB, SIGNAL( clicked() ),
	   this, SLOT( loadClicked() ) );

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->adjustSize();
  okPB->setFixedHeight(okPB->height());
  okPB->setMinimumWidth(okPB->width());
  hlayout2->addStretch(1);
  hlayout2->addWidget(okPB, 3);
  hlayout2->addStretch(1);
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), this);
  cancelPB->adjustSize();
  cancelPB->setFixedHeight(cancelPB->height());
  cancelPB->setMinimumWidth(cancelPB->width());
  hlayout2->addWidget(cancelPB, 3);
  hlayout2->addStretch(1);
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );
  vlayout1->activate();
  resize(10,10);
  setCaption( i18n( "Insert Include File" ) );
}

void InsertIncludeDialog::okClicked()
{
  if( !_view->currentBuffer()->isReadonly() ) {
	inset->setContents( filenameED->text() );
	// don't typeset
	inset->setNoLoad( donttypesetCB->isChecked() );
	if( inputRB->isChecked() )
	  inset->setInput();
	else if( includeRB->isChecked() )
	  inset->setInclude();
	else if( verbatimRB->isChecked() ) {
	  inset->setVerb();
	  inset->setVisibleSpace( visiblespaceCB->isChecked() );
	}
	UpdateInset(inset);
  }

  accept();
}


void InsertIncludeDialog::cancelClicked()
{
  reject();
}


void InsertIncludeDialog::browseClicked()
{
  // Should browsing too be disabled in RO-mode?
  LString mpath = OnlyPath(inset->getMasterFilename());
  LString ext;

  if( inputRB->isChecked() ) // Use Input Button
	ext = i18n("*.tex|TeX Documents (*.tex)");
  else if( verbatimRB->isChecked() ) // Verbatim all files
	ext = i18n("*|All Files");
  else
	ext = i18n("*.lyx|LyX Documents (*.lyx)");
  // launches dialog
  // Use by default the master's path
  LString filename = KFileDialog::getOpenFileName( mpath.c_str(),
						   ext.c_str(), k_tlw,
						   i18n("Select Child Document") ).data();

  QApplication::flushX();

  // check selected filename
  if (!filename.empty()) {
	LString filename2 = MakeRelPath(filename,
									mpath);
	if (filename2.prefixIs(".."))
	  filenameED->setText( filename.c_str() );
	else
	  filenameED->setText( filename2.c_str() );
  }
}


void InsertIncludeDialog::loadClicked()
{		
  if( !_view->currentBuffer()->isReadonly() ) {
	inset->setContents( filenameED->text() );
	inset->setNoLoad( donttypesetCB->isChecked() );
	if( inputRB->isChecked() )
	  inset->setInput();
	else if( includeRB->isChecked() )
	  inset->setInclude();
	else if( verbatimRB->isChecked() ) {
	  inset->setVerb();
	  inset->setVisibleSpace( visiblespaceCB->isChecked() );
	}

	UpdateInset(inset);
	_view->getLyXFunc()->Dispatch(LFUN_CHILDOPEN, inset->getContents().c_str());

	accept(); // Close dialog. Why?
  }
}


void InsertIncludeDialog::styleGroupClicked( int item )
{
  switch( item )
	{
	case 0: // include
	case 1: // input
	  visiblespaceCB->setChecked( false );
	  visiblespaceCB->setEnabled( false );
	  break;
	case 2: // verbatim
	  visiblespaceCB->setEnabled( true );
	}
}



/*
 * $Log: InsertIncludeDialog.C,v $
 * Revision 1.8  1999/01/06 13:32:15  kulow
 * aha! That explains it! I should have read the kfile docu first ;-)
 *
 * Revision 1.7  1998/08/09 15:18:32  ettrich
 * Matthias: uses kfiledialog now
 *
 * Revision 1.6  1998/03/27 16:32:29  kulow
 * use kfile out of kdelibs now.
 *
 * Revision 1.5  1998/03/10 16:54:10  kulow
 * made the file selector work.
 * Kalle: it must be OpenFileName, not OpenFileURL, unless you can handle urls
 *
 * Revision 1.4  1998/03/09 22:06:00  kalle
 * Towards 0.8.4...
 *
 * Loads of fixes and changes:
 * - added KFileDialog. --enable-kfiledialog uses it, otherwise QFileDialog is used
 * - font loading now faster and more robust
 * - prepared ParagraphDialog for line skips per paragraph (some code from Matthias is still missing)
 * - Changed the way the menus are created
 *
 * KLyX NOW REQUIRES QT 1.32!!!
 *
 * Revision 1.3  1998/03/03 21:00:30  kulow
 * new dialog
 *
 * Revision 1.2  1998/03/02 21:13:41  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.1  1998/02/11 09:15:02  kalle
 * - added InsertBibitemDialog
 * - added InertIncludeDialog
 *
 */
