/*
 * $Id: DocumentLayoutDialog.C,v 1.19 1998/09/04 16:07:39 ettrich Exp $
 */

#include "DocumentLayoutDialog.h"
#include <qslider.h>

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qcombo.h>
#include <qlabel.h>
#include <qlcdnum.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlayout.h>
#include "LyXView.h"
#include "BulletShapeDialog.h"
#include "lyx_gui_misc.h"

#include "tex-strings.h"

extern void DocumentApplyCB();
extern void DocumentDefskipCB_comboDefaultSkip( int );
extern void DocumentDefskipCB_editDefaultSkip( const char* );
extern void UpdateDocumentButtons( BufferParams const& );
extern void UpdateLayoutDocument( BufferParams const &params );

extern BufferView* current_view;

DocumentLayoutDialog::DocumentLayoutDialog( QWidget * parent=0,
					    const char * name=0,
					    WFlags f=0 ) :
  QDialog( parent, name, true, f )
{
  // toplevel layout
  QVBoxLayout *toplevelVB = new QVBoxLayout(this, 10);
  // buttons
  QHBoxLayout *buttonsHB = new QHBoxLayout(6);
  // body
  QHBoxLayout *bodyHB = new QHBoxLayout();

  toplevelVB->addLayout(bodyHB, 1);
  toplevelVB->addLayout(buttonsHB, 0);

  // left side
  QGridLayout *leftGR = new QGridLayout(19, 2, 3);
  // right side
  QVBoxLayout *rightVB = new QVBoxLayout();

  bodyHB->addLayout(leftGR, 2);
  bodyHB->addLayout(rightVB, 3);

  classLA = new QLabel( i18n( "Class:" ), this );
  classLA->adjustSize();
  classLA->setMinimumWidth(classLA->width());
  leftGR->addWidget(classLA, 1, 0);
  classLA->setAlignment( AlignRight );

  classCO = new QComboBox( false, this );
  classCO->adjustSize();
  classCO->setFixedHeight(classCO->height());
  classCO->setMinimumWidth(classCO->width());
  connect( classCO, SIGNAL( activated( int ) ),
		   this, SLOT( classComboActivated( int ) ) );
  leftGR->addWidget(classCO, 1, 1);

  pagestyleLA = new QLabel( i18n( "Pagestyle:" ), this );
  pagestyleLA->adjustSize();
  pagestyleLA->setMinimumWidth(pagestyleLA->width());
  leftGR->addWidget(pagestyleLA, 3, 0);
  pagestyleLA->setAlignment( AlignRight );

  pagestyleCO = new QComboBox( false, this );
  leftGR->addWidget(pagestyleCO, 3, 1);
  pagestyleCO->insertItem( "default", DocumentLayoutDialogData::PageStyleDefault );
  pagestyleCO->insertItem( "empty", DocumentLayoutDialogData::Empty );
  pagestyleCO->insertItem( "plain", DocumentLayoutDialogData::Plain );
  pagestyleCO->insertItem( "headings", DocumentLayoutDialogData::Headings );
  pagestyleCO->insertItem( "fancy", DocumentLayoutDialogData::Fancy );
  pagestyleCO->adjustSize();
  pagestyleCO->setFixedHeight(pagestyleCO->height());
  pagestyleCO->setMinimumWidth(pagestyleCO->width());

  fontsLA = new QLabel( i18n( "Fonts:" ), this );
  fontsLA->adjustSize();
  fontsLA->setMinimumWidth(fontsLA->width());
  leftGR->addWidget(fontsLA, 5, 0);
  fontsLA->setAlignment( AlignRight );

  fontsCO = new QComboBox( false, this );
  fontsCO->adjustSize();
  fontsCO->setFixedHeight(fontsCO->height());
  fontsCO->setMinimumWidth(fontsCO->width());
  leftGR->addWidget(fontsCO, 5, 1);
  fontsCO->insertItem( "default", DocumentLayoutDialogData::FontsDefault );
  fontsCO->insertItem( "times", DocumentLayoutDialogData::Times );
  fontsCO->insertItem( "palatino", DocumentLayoutDialogData::Palatino );
  fontsCO->insertItem( "helvet", DocumentLayoutDialogData::Helvet );
  fontsCO->insertItem( "avant", DocumentLayoutDialogData::Avant );
  fontsCO->insertItem( "newcent", DocumentLayoutDialogData::NewCent );
  fontsCO->insertItem( "bookman", DocumentLayoutDialogData::Bookman );


  fontsizeLA = new QLabel( i18n( "Font Size:" ), this );
  fontsizeLA->adjustSize();
  fontsizeLA->setMinimumWidth(fontsizeLA->width());
  leftGR->addWidget(fontsizeLA, 7, 0);
  fontsizeLA->setAlignment( AlignRight );

  fontsizeCO = new QComboBox( false, this );
  fontsizeCO->adjustSize();
  fontsizeCO->setFixedHeight(fontsizeCO->height());
  fontsizeCO->setMinimumWidth(fontsizeCO->width());
  leftGR->addWidget(fontsizeCO, 7, 1);
  fontsizeCO->insertItem( "default",
			  DocumentLayoutDialogData::FontSizeDefault );
  fontsizeCO->insertItem( "10", DocumentLayoutDialogData::FontSize10 );
  fontsizeCO->insertItem( "11", DocumentLayoutDialogData::FontSize11 );
  fontsizeCO->insertItem( "12", DocumentLayoutDialogData::FontSize12 );


  languageLA = new QLabel( i18n( "Language:" ), this );
  languageLA->adjustSize();
  languageLA->setMinimumWidth(languageLA->width());
  leftGR->addWidget(languageLA, 9, 0);
  languageLA->setAlignment( AlignRight );

  languageCO = new QComboBox( false, this );
  languageCO->adjustSize();
  languageCO->setFixedHeight(languageCO->height());
  languageCO->setMinimumWidth(languageCO->width());
  leftGR->addWidget(languageCO, 9, 1);
  languageCO->insertItem( "default",
			  DocumentLayoutDialogData::LanguageDefault );
  languageCO->insertItem( "afrikaans", DocumentLayoutDialogData::Afrikaans );
  languageCO->insertItem( "american", DocumentLayoutDialogData::American );
  languageCO->insertItem( "austrian", DocumentLayoutDialogData::Austrian );
  languageCO->insertItem( "bahasa", DocumentLayoutDialogData::Bahasa );
  languageCO->insertItem( "brazil", DocumentLayoutDialogData::Brazil );
  languageCO->insertItem( "breton", DocumentLayoutDialogData::Breton );
  languageCO->insertItem( "catalan", DocumentLayoutDialogData::Catalan );
  languageCO->insertItem( "croatian", DocumentLayoutDialogData::Croatian );
  languageCO->insertItem( "czech", DocumentLayoutDialogData::Czech );
  languageCO->insertItem( "danish", DocumentLayoutDialogData::Danish );
  languageCO->insertItem( "dutch", DocumentLayoutDialogData::Dutch );
  languageCO->insertItem( "english", DocumentLayoutDialogData::English );
  languageCO->insertItem( "esperanto", DocumentLayoutDialogData::Esperanto );
  languageCO->insertItem( "estonian", DocumentLayoutDialogData::Estonian );
  languageCO->insertItem( "finnish", DocumentLayoutDialogData::Finnish );
  languageCO->insertItem( "french", DocumentLayoutDialogData::French );
  languageCO->insertItem( "frenchb", DocumentLayoutDialogData::Frenchb );
  languageCO->insertItem( "galician", DocumentLayoutDialogData::Galician );
  languageCO->insertItem( "german", DocumentLayoutDialogData::German );
  languageCO->insertItem( "greek", DocumentLayoutDialogData::Greek );
  languageCO->insertItem( "hungarian", DocumentLayoutDialogData::Hungarian );
  languageCO->insertItem( "irish", DocumentLayoutDialogData::Irish );
  languageCO->insertItem( "italian", DocumentLayoutDialogData::Italian );
  languageCO->insertItem( "isorbian", DocumentLayoutDialogData::Isorbian );
  languageCO->insertItem( "magyar", DocumentLayoutDialogData::Magyar );
  languageCO->insertItem( "norwegian", DocumentLayoutDialogData::Norwegian );
  languageCO->insertItem( "polish", DocumentLayoutDialogData::Polish );
  languageCO->insertItem( "portuguese", DocumentLayoutDialogData::Portuguese );
  languageCO->insertItem( "romanian", DocumentLayoutDialogData::Romanian );
  languageCO->insertItem( "russian", DocumentLayoutDialogData::Russian );
  languageCO->insertItem( "scottish", DocumentLayoutDialogData::Scottish );
  languageCO->insertItem( "slovak", DocumentLayoutDialogData::Slovak );
  languageCO->insertItem( "slovene", DocumentLayoutDialogData::Slovene );
  languageCO->insertItem( "spanish", DocumentLayoutDialogData::Spanish );
  languageCO->insertItem( "surkish", DocumentLayoutDialogData::Turkish );
  languageCO->insertItem( "usorbian", DocumentLayoutDialogData::Usorbian );
  languageCO->insertItem( "welsh", DocumentLayoutDialogData::Welsh );

  psdriverLA = new QLabel( i18n( "PS Driver:" ), this );
  psdriverLA->adjustSize();
  psdriverLA->setMinimumWidth(psdriverLA->width());
  leftGR->addWidget(psdriverLA, 11, 0);
  psdriverLA->setAlignment( AlignRight );

  psdriverCO = new QComboBox( false, this );
  psdriverCO->adjustSize();
  psdriverCO->setFixedHeight(psdriverCO->height());
  psdriverCO->setMinimumWidth(psdriverCO->width());
  leftGR->addWidget(psdriverCO, 11, 1);
  psdriverCO->insertItem( "default",
			  DocumentLayoutDialogData::PSDriverDefault );
  psdriverCO->insertItem( "dvips", DocumentLayoutDialogData::Dvips );
  psdriverCO->insertItem( "dvitops", DocumentLayoutDialogData::Dvitops );
  psdriverCO->insertItem( "emTeX", DocumentLayoutDialogData::Emtex );
  psdriverCO->insertItem( "ln", DocumentLayoutDialogData::Ln );
  psdriverCO->insertItem( "oztex", DocumentLayoutDialogData::Oztex );
  psdriverCO->insertItem( "textures", DocumentLayoutDialogData::Textures );
  psdriverCO->insertItem( "none", DocumentLayoutDialogData::PSDriverNone );


  encodingLA = new QLabel( i18n( "Encoding:" ), this );
  encodingLA->adjustSize();
  encodingLA->setMinimumWidth(encodingLA->width());
  leftGR->addWidget(encodingLA, 13, 0);
  encodingLA->setAlignment( AlignRight );

  encodingCO = new QComboBox( false, this );
  encodingCO->adjustSize();
  encodingCO->setFixedHeight(encodingCO->height());
  encodingCO->setMinimumWidth(encodingCO->width());
  leftGR->addWidget(encodingCO, 13, 1);
  encodingCO->insertItem( "default",
			  DocumentLayoutDialogData::EncodingDefault );
  encodingCO->insertItem( "latin1", DocumentLayoutDialogData::Latin1 );
  encodingCO->insertItem( "latin2", DocumentLayoutDialogData::Latin2 );
  encodingCO->insertItem( "latin5", DocumentLayoutDialogData::Latin5 );

  defaultskipLA = new QLabel( i18n( "Default Skip:" ), this );
  defaultskipLA->adjustSize();
  defaultskipLA->setMinimumWidth(defaultskipLA->width());
  leftGR->addWidget(defaultskipLA, 15, 0);
  defaultskipLA->setAlignment( AlignRight );

  QHBoxLayout *hlayout3 = new QHBoxLayout(5);
  leftGR->addLayout(hlayout3, 15, 1);
  defaultskipCO = new QComboBox( false, this );
  hlayout3->addWidget(defaultskipCO, 3);
  defaultskipCO->insertItem( "Smallskip",
			     DocumentLayoutDialogData::Smallskip );
  defaultskipCO->insertItem( "Medskip", DocumentLayoutDialogData::Medskip );
  defaultskipCO->insertItem( "Bigskip", DocumentLayoutDialogData::Bigskip );
  defaultskipCO->insertItem( "Length", DocumentLayoutDialogData::Length );
  defaultskipCO->adjustSize();
  defaultskipCO->setFixedHeight(defaultskipCO->height());
  defaultskipCO->setMinimumWidth(defaultskipCO->width());

  defaultskipED = new QLineEdit( this );
  defaultskipED->adjustSize();
  defaultskipED->setFixedHeight(defaultskipCO->height());
  defaultskipED->setMinimumWidth(defaultskipED->width());
  hlayout3->addWidget(defaultskipED, 2);
  connect( defaultskipED, SIGNAL( textChanged( const char* ) ),
		   SLOT( defaultskipTextChanged( const char * ) ) );

  spacingLA = new QLabel( i18n( "Spacing:" ), this );
  spacingLA->adjustSize();
  spacingLA->setMinimumSize(spacingLA->size());
  leftGR->addWidget(spacingLA, 17, 0);
  spacingLA->setAlignment( AlignRight );

  QHBoxLayout* hlayout4 = new QHBoxLayout( 5 );
  leftGR->addLayout( hlayout4, 17, 1);
  spacingCO = new QComboBox( false, this );
  hlayout4->addWidget( spacingCO, 3 );
  spacingCO->insertItem( "Single", DocumentLayoutDialogData::Single );
  spacingCO->insertItem( "Onehalf", DocumentLayoutDialogData::Onehalf );
  spacingCO->insertItem( "Double", DocumentLayoutDialogData::Double );
  spacingCO->insertItem( "Other", DocumentLayoutDialogData::Other );
  spacingCO->adjustSize();
  spacingCO->setFixedHeight(spacingCO->height());
  spacingCO->setMinimumWidth(spacingCO->width());

  spacingED = new QLineEdit( this );
  spacingED->adjustSize();
  spacingED->setFixedHeight( spacingCO->height() );
  spacingED->setMinimumWidth( spacingED->width() );
  hlayout4->addWidget( spacingED, 2 );
  connect( spacingED, SIGNAL( textChanged( const char* ) ),
		   SLOT( spacingTextChanged( const char * ) ) );


  QGridLayout *groupsGR = new QGridLayout(2, 2);
  rightVB->addStretch(1);
  rightVB->addLayout(groupsGR);

  sidesBG = new QButtonGroup( i18n( "Sides" ), this );
  groupsGR->addWidget(sidesBG, 0, 0);

  QVBoxLayout *sidesVB = new QVBoxLayout( sidesBG, 18, 3);
  sidesoneRB = new QRadioButton( i18n( "One" ), sidesBG );
  sidesoneRB->adjustSize();
  sidesoneRB->setMinimumSize(sidesoneRB->size());
  sidesVB->addWidget(sidesoneRB);
  sidesoneRB->setChecked( true );

  sidestwoRB = new QRadioButton( i18n( "Two" ), sidesBG );
  sidestwoRB->adjustSize();
  sidestwoRB->setMinimumSize(sidestwoRB->size());
  sidesVB->addWidget(sidestwoRB);
  sidesVB->activate();

  columnsBG = new QButtonGroup( i18n( "Columns" ), this );
  groupsGR->addWidget(columnsBG, 0, 1);
  QVBoxLayout *columnsVB = new QVBoxLayout( columnsBG, 18, 3);

  columnsoneRB = new QRadioButton( i18n( "One" ), columnsBG);
  columnsoneRB->adjustSize();
  columnsoneRB->setMinimumSize(columnsoneRB->size());
  columnsVB->addWidget(columnsoneRB);
  columnsoneRB->setChecked( true );

  columnstwoRB = new QRadioButton( i18n( "Two" ), columnsBG );
  columnstwoRB->adjustSize();
  columnstwoRB->setMinimumSize(columnstwoRB->size());
  columnsVB->addWidget(columnstwoRB);
  columnstwoRB->setChecked( false );
  columnsVB->activate();

  separationBG = new QButtonGroup( i18n( "Separation" ), this );
  groupsGR->addWidget(separationBG, 1, 0);
  QVBoxLayout *separationVB = new QVBoxLayout( separationBG, 18, 3);

  indentRB = new QRadioButton( i18n( "&Indent" ), separationBG );
  indentRB->adjustSize();
  indentRB->setMinimumSize(indentRB->size());
  separationVB->addWidget(indentRB);
  indentRB->setChecked( true );

  skipRB = new QRadioButton( i18n( "S&kip" ), separationBG );
  skipRB->adjustSize();
  skipRB->setMinimumSize(skipRB->size());
  separationVB->addWidget(skipRB);
  separationVB->activate();

  QVBoxLayout *bulletVB = new QVBoxLayout(10);
  groupsGR->addLayout(bulletVB, 1, 1);
  bulletVB->addStretch(1);
  bulletshapesPB = new QPushButton( i18n( "&Bullet Shapes" ), this);
  bulletshapesPB->adjustSize();
  bulletshapesPB->setFixedHeight(bulletshapesPB->height());
  bulletshapesPB->setMinimumWidth(bulletshapesPB->width());
  bulletVB->addWidget(bulletshapesPB, 0);
  bulletVB->addStretch(1);
  connect( bulletshapesPB, SIGNAL( clicked() ), SLOT( showBulletShapes() ) );

  amsmathCB = new QCheckBox( i18n( "Use A&MS Math" ), this );
  amsmathCB->adjustSize();
  amsmathCB->setMinimumSize(amsmathCB->size());
  bulletVB->addWidget(amsmathCB, 0);
  bulletVB->addStretch(1);

  QGridLayout *floatGR = new QGridLayout(2, 2);
  rightVB->addStretch(1);
  rightVB->addLayout(floatGR);
  floatplacementLA = new QLabel( i18n( "Float placement" ), this);
  floatplacementLA->adjustSize();
  floatplacementLA->setMinimumSize(floatplacementLA->size());
  floatGR->addWidget(floatplacementLA, 0,0);
  floatplacementLA->setAlignment( AlignRight );

  floatplacementED = new QLineEdit( this );
  floatplacementED->adjustSize();
  floatplacementED->setFixedHeight(floatplacementED->height());
  floatplacementED->setMinimumWidth(floatplacementED->width());
  floatGR->addWidget(floatplacementED, 0,1);

  extraoptionsLA = new QLabel( i18n( "Extra options" ), this);
  extraoptionsLA->adjustSize();
  extraoptionsLA->setMinimumSize(extraoptionsLA->size());
  floatGR->addWidget(extraoptionsLA, 1,0);
  extraoptionsLA->setAlignment( AlignRight );

  extraoptionsED = new QLineEdit( this );
  extraoptionsED->adjustSize();
  extraoptionsED->setFixedHeight(extraoptionsED->height());
  extraoptionsED->setMinimumWidth(extraoptionsED->width());
  floatGR->addWidget(extraoptionsED, 1,1);

  QGridLayout *secsGR = new QGridLayout(2, 3);
  rightVB->addStretch(1);
  rightVB->addLayout(secsGR);
  rightVB->addStretch(1);
  secnumdepthLA = new QLabel( i18n( "Section number depth" ), this);
  secnumdepthLA->adjustSize();
  secnumdepthLA->setMinimumSize(secnumdepthLA->size());
  secsGR->addWidget(secnumdepthLA, 0, 0);
  secnumdepthLA->setAlignment( AlignRight );

  secnumdepthSL = new QSlider( -1, 5, 1, 3, QSlider::Horizontal, this );
  secnumdepthSL->adjustSize();
  secnumdepthSL->setMinimumWidth(secnumdepthSL->width());
  secsGR->addWidget(secnumdepthSL, 0, 1);

  secnumdepthLC = new QLCDNumber( 2, this );
  secnumdepthLC->adjustSize();
  secnumdepthLC->setMinimumSize(secnumdepthLC->size());
  secnumdepthLC->setMaximumHeight(secnumdepthLC->height());
  secsGR->addWidget(secnumdepthLC, 0, 2);
  connect( secnumdepthSL, SIGNAL( valueChanged( int ) ),
	   secnumdepthLC, SLOT( display( int ) ) );

  tocdepthLA = new QLabel( i18n( "Table of contents depth" ), this);
  tocdepthLA->adjustSize();
  tocdepthLA->setMinimumSize(tocdepthLA->size());
  secsGR->addWidget(tocdepthLA, 1, 0);
  tocdepthLA->setAlignment( AlignRight );

  tocdepthSL = new QSlider( -1, 5, 1, 3, QSlider::Horizontal, this );
  secsGR->addWidget(tocdepthSL, 1, 1);

  tocdepthLC = new QLCDNumber( 2, this );
  tocdepthLC->adjustSize();
  tocdepthLC->setMinimumSize(tocdepthLC->size());
  tocdepthLC->setMaximumHeight(tocdepthLC->height());

  secsGR->addWidget(tocdepthLC, 1, 2);
  connect( tocdepthSL, SIGNAL( valueChanged( int ) ),
	   tocdepthLC, SLOT( display( int ) ) );

  buttonsHB->addStretch(3);
  okPB = new QPushButton( i18n( "OK" ), this );
  okPB->adjustSize();
  okPB->setFixedHeight(okPB->height());
  okPB->setMinimumWidth(okPB->width());
  buttonsHB->addWidget(okPB, 1);
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  applyPB = new QPushButton( i18n( "Apply" ), this );
  applyPB->adjustSize();
  applyPB->setFixedHeight(applyPB->height());
  applyPB->setMinimumWidth(applyPB->width());
  buttonsHB->addWidget(applyPB, 1);
  connect( applyPB, SIGNAL( clicked() ), SLOT( applyClicked() ) );

  cancelPB = new QPushButton( i18n( "Cancel" ), this );
  cancelPB->adjustSize();
  cancelPB->setFixedHeight(cancelPB->height());
  cancelPB->setMinimumWidth(cancelPB->width());
  buttonsHB->addWidget(cancelPB, 1);
  connect( cancelPB, SIGNAL( clicked() ), SLOT( reject() ) );

  for (int i = 0; i < 19; i++)
    leftGR->setRowStretch(i, 1);
  leftGR->setRowStretch(15, 0); // the one with the layout

  toplevelVB->activate();
  resize(10,10);
  setCaption( i18n( "Document layout" ) );
}


DocumentLayoutDialog::~DocumentLayoutDialog()
{
}


void DocumentLayoutDialog::showBulletShapes()
{
  if( !klyxdialogs->bulletshape )
	klyxdialogs->bulletshape = new BulletShapeDialog( current_view->getOwner() );

  klyxdialogs->bulletshape->init();

  (void)klyxdialogs->bulletshape->exec();
}


void DocumentLayoutDialog::classComboActivated( int item )
{
  if( AskQuestion( i18n( "Should I set some parameters to" ),
				   classCO->text( item ),
				   i18n( "the defaults of this document class?" ) ) ) {
	BufferParams params = BufferParams();
	params.textclass = item;
	params.useClassDefaults();
	UpdateDocumentButtons( params );
	UpdateLayoutDocument( params );
  }
}


void DocumentLayoutDialog::setData( DocumentLayoutDialogData* data )
{
  classCO->setCurrentItem( data->_class );
  pagestyleCO->setCurrentItem( data->pagestyle );
  fontsCO->setCurrentItem( data->fonts );
  fontsizeCO->setCurrentItem( data->font_size );
  languageCO->setCurrentItem( data->language );
  psdriverCO->setCurrentItem( data->ps_driver );
  encodingCO->setCurrentItem( data->encoding );
  defaultskipCO->setCurrentItem( data->default_skip );
  defaultskipED->setText( data->default_skip_length );
  spacingCO->setCurrentItem( data->spacing );
  spacingED->setText( data->spacing_length );
  amsmathCB->setChecked( data->amsmath );

  switch( data->sides )
	{
	case DocumentLayoutDialogData::OneSide:
	  sidesoneRB->setChecked( true );
	  sidestwoRB->setChecked( false );
	  break;
	case DocumentLayoutDialogData::TwoSides:
	  sidesoneRB->setChecked( false );
	  sidestwoRB->setChecked( true );
	  break;
	};

  switch( data->columns )
	{
	case DocumentLayoutDialogData::OneColumn:
	  columnsoneRB->setChecked( true );
	  columnstwoRB->setChecked( false );
	  break;
	case DocumentLayoutDialogData::TwoColumns:
	  columnsoneRB->setChecked( false );
	  columnstwoRB->setChecked( true );
	  break;
	};

  switch( data->separation )
	{
	case DocumentLayoutDialogData::Indent:
	  indentRB->setChecked( true );
	  skipRB->setChecked( false );
	  break;
	case DocumentLayoutDialogData::Skip:
	  indentRB->setChecked( false );
	  skipRB->setChecked( true );
	  break;
	};
	

  floatplacementED->setText( data->float_placement );
  extraoptionsED->setText( data->extra_options );

  secnumdepthSL->setValue( data->section_number_depth );
  secnumdepthLC->display( data->section_number_depth );
  tocdepthSL->setValue( data->table_of_contents_depth );
  tocdepthLC->display( data->table_of_contents_depth );
}


static DocumentLayoutDialogData tempdata;

DocumentLayoutDialogData* DocumentLayoutDialog::data() const
{
  tempdata._class = classCO->currentItem();
  tempdata.pagestyle =
	(DocumentLayoutDialogData::Pagestyle)pagestyleCO->currentItem();
  tempdata.fonts =
	(DocumentLayoutDialogData::Fonts)fontsCO->currentItem();
  tempdata.font_size =
	(DocumentLayoutDialogData::FontSize)fontsizeCO->currentItem();
  tempdata.language =
	(DocumentLayoutDialogData::Language)languageCO->currentItem();
  tempdata.ps_driver =
	(DocumentLayoutDialogData::PSDriver)psdriverCO->currentItem();
  tempdata.encoding =
	(DocumentLayoutDialogData::Encoding)encodingCO->currentItem();
  tempdata.default_skip =
	(DocumentLayoutDialogData::DefaultSkip)defaultskipCO->currentItem();
  tempdata.default_skip_length = defaultskipED->text();
  tempdata.spacing =
	(DocumentLayoutDialogData::Spacing)spacingCO->currentItem();
  tempdata.spacing_length = spacingED->text();
  tempdata.amsmath = amsmathCB->isChecked();

  if( sidesoneRB->isChecked() )
	tempdata.sides = DocumentLayoutDialogData::OneSide;
  else if( sidestwoRB->isChecked() )
	tempdata.sides = DocumentLayoutDialogData::TwoSides;
  else
	lyxerr_debug( "Cannot determine value for DocumentLayoutDialog::sides" );

  if( columnsoneRB->isChecked() )
	tempdata.columns = DocumentLayoutDialogData::OneColumn;
  else if( columnstwoRB->isChecked() )
	tempdata.columns = DocumentLayoutDialogData::TwoColumns;
  else
	lyxerr_debug( "Cannot determine value for DocumentLayoutDialog::columns" );

  if( indentRB->isChecked() )
	tempdata.separation = DocumentLayoutDialogData::Indent;
  else if( skipRB->isChecked() )
	tempdata.separation = DocumentLayoutDialogData::Skip;
  else
	lyxerr_debug( "Cannot determine value for DocumentLayoutDialog::separation" );

  tempdata.float_placement = floatplacementED->text();
  tempdata.extra_options = extraoptionsED->text();

  tempdata.section_number_depth = secnumdepthSL->value();
  tempdata.table_of_contents_depth = tocdepthSL->value();

  return &tempdata;
}


void DocumentLayoutDialog::applyClicked()
{
  emit apply();
}

void DocumentLayoutDialog::okClicked()
{
  emit apply();
  accept();
}


void DocumentLayoutDialog::defaultskipTextChanged( const char* text )
{
  if( text && text[0] )
	defaultskipCO->setCurrentItem( DocumentLayoutDialogData::Length );
}


void DocumentLayoutDialog::spacingTextChanged( const char* text )
{
  if( text && text[0] )
	spacingCO->setCurrentItem( DocumentLayoutDialogData::Other );
}


int DocumentLayoutDialog::stringToClass( const QString& classString )
{
  for( int i = 0; i < classCO->count(); i++ )
	if( classString == classCO->text( i ) )
	  return i;

  debug( "Could not find class string in __file__, __line__" );
  return 0;
}

DocumentLayoutDialogData::Language DocumentLayoutDialog::stringToLanguage( const QString& languageString )
{
  for( int i = 0; i < languageCO->count(); i++ )
	if( languageString == languageCO->text( i ) )
	  return (DocumentLayoutDialogData::Language)i;

  debug( "Could not find language string in __file__, __line__" );
  return (DocumentLayoutDialogData::Language)0;
}

DocumentLayoutDialogData::Fonts DocumentLayoutDialog::stringToFonts( const QString& fontsString )
{
  for( int i = 0; i < fontsCO->count(); i++ )
	if( fontsString == fontsCO->text( i ) )
	  return (DocumentLayoutDialogData::Fonts)i;

  debug( "Could not find fonts string in __file__, __line__" );
  return (DocumentLayoutDialogData::Fonts)0;
}

DocumentLayoutDialogData::Encoding DocumentLayoutDialog::stringToEnc( const QString& encodingString )
{
  for( int i = 0; i < encodingCO->count(); i++ )
	if( encodingString == encodingCO->text( i ) )
	  return (DocumentLayoutDialogData::Encoding)i;

  debug( "Could not find encoding string in __file__, __line__" );
  return (DocumentLayoutDialogData::Encoding)0;
}

DocumentLayoutDialogData::PSDriver DocumentLayoutDialog::stringToPSDriver( const QString& psdriverString )
{
  for( int i = 0; i < psdriverCO->count(); i++ )
	if( psdriverString == psdriverCO->text( i ) )
	  return (DocumentLayoutDialogData::PSDriver)i;

  debug( "Could not find psdriver string in __file__, __line__" );
  return (DocumentLayoutDialogData::PSDriver)0;
}


QString DocumentLayoutDialog::numToFontString( int font )
{
  return fontsCO->text( font );
}

QString DocumentLayoutDialog::numToFontSizeString( int font_size )
{
  return fontsizeCO->text( font_size );
}

QString DocumentLayoutDialog::numToInputencString( int encoding )
{
  return encodingCO->text( encoding );
}

QString DocumentLayoutDialog::numToPageStyleString( int page_style )
{
  return pagestyleCO->text( page_style );
}

QString DocumentLayoutDialog::numToPostScriptDriverString( int ps_driver )
{
  return psdriverCO->text( ps_driver );
}

QString DocumentLayoutDialog::numToLanguageString( int language )
{
  return languageCO->text( language );
}


void DocumentLayoutDialog::disable()
{
  classCO->setEnabled( false );
  pagestyleCO->setEnabled( false );
  fontsCO->setEnabled( false );
  fontsizeCO->setEnabled( false );
  languageCO->setEnabled( false );
  psdriverCO->setEnabled( false );
  encodingCO->setEnabled( false );
  defaultskipCO->setEnabled( false );
  defaultskipED->setEnabled( false );
  spacingCO->setEnabled( false );
  spacingED->setEnabled( false );
  sidesBG->setEnabled( false );
  sidesoneRB->setEnabled( false );
  sidestwoRB->setEnabled( false );
  columnsBG->setEnabled( false );
  columnsoneRB->setEnabled( false );
  columnstwoRB->setEnabled( false );
  separationBG->setEnabled( false );
  indentRB->setEnabled( false );
  skipRB->setEnabled( false );
  floatplacementED->setEnabled( false );
  extraoptionsED->setEnabled( false );
  secnumdepthSL->setEnabled( false );
  secnumdepthLC->setEnabled( false );
  tocdepthSL->setEnabled( false );
  tocdepthLC->setEnabled( false );
  amsmathCB->setEnabled( false );
}


void DocumentLayoutDialog::enable()
{
  classCO->setEnabled( true );
  pagestyleCO->setEnabled( true );
  fontsCO->setEnabled( true );
  fontsizeCO->setEnabled( true );
  languageCO->setEnabled( true );
  psdriverCO->setEnabled( true );
  encodingCO->setEnabled( true );
  defaultskipCO->setEnabled( true );
  defaultskipED->setEnabled( true );
  spacingCO->setEnabled( true );
  spacingED->setEnabled( true );
  sidesBG->setEnabled( true );
  sidesoneRB->setEnabled( true );
  sidestwoRB->setEnabled( true );
  columnsBG->setEnabled( true );
  columnsoneRB->setEnabled( true );
  columnstwoRB->setEnabled( true );
  separationBG->setEnabled( true );
  indentRB->setEnabled( true );
  skipRB->setEnabled( true );
  floatplacementED->setEnabled( true );
  extraoptionsED->setEnabled( true );
  secnumdepthSL->setEnabled( true );
  secnumdepthLC->setEnabled( true );
  tocdepthSL->setEnabled( true );
  tocdepthLC->setEnabled( true );
  amsmathCB->setEnabled( true );
}


DocumentLayoutDialogReceiver::DocumentLayoutDialogReceiver( DocumentLayoutDialog* dlg )
{
  QObject::connect( dlg, SIGNAL( apply() ), this, SLOT( apply() ) );
  _dlg = dlg;

  QObject::connect( dlg->defaultskipCO, SIGNAL( activated( int ) ),
					this, SLOT( comboDefaultSkip( int ) ) );
  QObject::connect( dlg->defaultskipED, SIGNAL( textChanged( const char* ) ),
					this, SLOT( editDefaultSkip( const char* ) ) );
  QObject::connect( dlg->spacingCO, SIGNAL( activated( int ) ),
					this, SLOT( comboSpacing( int ) ) );
  QObject::connect( dlg->spacingED, SIGNAL( textChanged( const char* ) ),
					this, SLOT( editSpacing( const char* ) ) );
}

DocumentLayoutDialogReceiver::~DocumentLayoutDialogReceiver()
{
  QObject::disconnect( _dlg, SIGNAL( apply() ), this, SLOT( apply() ) );
}


void DocumentLayoutDialogReceiver::apply()
{
  DocumentApplyCB();
}


void DocumentLayoutDialogReceiver::comboDefaultSkip( int selection )
{
  DocumentDefskipCB_comboDefaultSkip( selection );
}


void DocumentLayoutDialogReceiver::editDefaultSkip( const char* text )
{
  DocumentDefskipCB_editDefaultSkip( text );
}


void DocumentLayoutDialogReceiver::comboSpacing( int selection )
{
  if (selection != DocumentLayoutDialogData::Other)
    _dlg->spacingED->setText("");
}


void DocumentLayoutDialogReceiver::editSpacing( const char* text ) {
  if (_dlg->spacingCO->currentItem() != DocumentLayoutDialogData::Other)
    _dlg->spacingCO->setCurrentItem(DocumentLayoutDialogData::Other);
}


/*
 * $Log: DocumentLayoutDialog.C,v $
 * Revision 1.19  1998/09/04 16:07:39  ettrich
 * Matthias: bugfixes
 *
 * Revision 1.18  1998/08/05 11:04:10  kuepper
 * Added type specifiers to some variable declarations. Added return type
 * specifiers to several functions extern declarations.
 *
 * Revision 1.17  1998/07/31 16:13:20  kuepper
 * QBoxLayout hlayout4 doesn't need to be activated, since it is a
 * child-layout of leftGR.
 *
 * Revision 1.16  1998/06/09 13:08:12  schreter
 *
 *
 * Added support for autodetection of charset, document encoding and
 * document language. tex_babel was changed to contain locale codes for
 * languages for autodetection of language from locale. Somebody please
 * revise it, so that it contains proper locale codes for all languages.
 *
 * Revision 1.15  1998/04/14 16:08:48  ettrich
 * Matthias: fixed lots of nasty bug (should no longer segfault when
 *   exiting :-)
 *
 * Revision 1.14  1998/03/28 22:15:24  kalle
 * - Pagestyles in DocumentLayoutDialog are dynamically updated when changing text classes
 * - InsertCitationDialog starts up with correct bibliographic reference
 * - Added Goto button to DocumentStructureDialog
 *
 * Revision 1.13  1998/03/12 15:32:17  ettrich
 * Matthias:
 *
 *       spacing for paragraphs, bugfixes, cleanups
 *
 * Revision 1.12  1998/03/10 18:52:53  kalle
 * Added a text field to allow entering a value for "other" spacing.
 *
 * Matthias: You can that value with DocumentLayoutDialog::getData()->spacing_length;
 *
 * Revision 1.11  1998/03/09 11:28:09  kulow
 * fixed several problems found by purify
 *
 * Revision 1.10  1998/03/04 12:15:44  kulow
 * I guess, this one was my diploma piece. 144 new lines with all kind of
 * parameters for the dialog. 43 setGeometry less ;-)
 *
 * Revision 1.9  1998/03/03 22:25:36  kulow
 * rewrote the dialog using Geometry managment classes. It looks very, very
 * strange, since I haven't added stretch factors and min/max sizes. I'm just
 * too tired of using adjustSize for today, so I will add this, when I get up.
 *
 * Revision 1.8  1998/03/01 21:54:47  kalle
 * - added MathBrowser for functions
 * - added AMSMath
 * - tried to replace LYX_DIR (in vain)
 *
 * Revision 1.7  1998/02/27 00:53:53  ettrich
 * Matthias: a couple of small bugfixes and lots of typos corrected:
 *       The DocumentLayoutDialog finally works as expected :-)
 *
 * Revision 1.6  1998/02/26 00:48:23  ettrich
 * Matthias: small typo corrected
 *
 * Revision 1.5  1998/02/11 21:49:46  ettrich
 * Matthias: TableLayout no longer necessary. Bugfixes.
 *
 * Revision 1.4  1998/02/03 23:41:52  kalle
 * BulletShapeDialog sort of works
 * It took me two Maribo Pilsner to get this far!
 * Still no images in BulletShapeDialog (will add these tomorrow)
 *
 * Revision 1.3  1998/01/28 22:44:17  kalle
 * activated new ParagraphExtraDialog (still buggy, and I don't understand
 * the options anyway :-))
 * 1626 XForms calls left (this was a good one)
 * fixed a bug in the document layout dialog
 *
 * Revision 1.2  1998/01/07 17:49:26  kalle
 * - QKBrowseBox fixed, works like a charm now!
 * - Several MathBrowsers fixed, work nicely, too
 * - Fixed bug in DocumentApplyCB
 * - Started more work on screen options
 *
 * Revision 1.1.1.1  1997/12/14 21:19:45  kalle
 * Imported current version. Does not compile...
 *
 * Revision 1.2  1997/12/09 21:22:23  kalle
 * DocumentLayoutDialog switched to Qt
 *
 * Revision 1.1  1997/11/26 16:11:14  kalle
 * Kalle: First dialogs for LyX
 *
 * Revision 1.1  1997/11/17 17:29:32  kalle
 * DocumentLayoutDialog added
 *
 */
