/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 *	     Copyright (C) 1995 Matthias Ettrich
 *        
 *           This file is Copyright (C) 1996, 1997
 *           Lars Gullik Bjnnes
 *
 * ======================================================
 */

#include <config.h>

#include "DepTable.h"
#include "lyxlib.h"
#include "filetools.h"


DepTable::DepTable()
{
	new_sum = 0;
	old_sum = 0;
	next = NULL;
}


DepTable::DepTable(LString const &f,
		   unsigned long one,
		   unsigned long two)
{
	file = f; new_sum = 0; old_sum = 0;
	if (one != 0)
		new_sum = one;
	if (two != 0)
		old_sum = two;
	next = NULL;
}


void DepTable::insert(LString const &f,
		      unsigned long one,
		      unsigned long two)
{
	if (f == file) return;
	if (next)
		next->insert(f, one, two);
	else
		next = new DepTable(f, one, two);
}
		

void DepTable::update()
{
	if (!file.empty()) {
		old_sum = new_sum;
		new_sum = lyxsum(file.c_str());
		//lyxerr.debug("update: " + file + " " +
		//	      int(new_sum) + " " + int(old_sum));
	}
	if (next) next->update();
}


bool DepTable::sumchange()
{
	bool ret = false;
	
	if (!file.empty()) {
		if (old_sum != new_sum) ret = true;
	}
	if (!ret && next) ret = next->sumchange();

	return ret;
}


bool DepTable::haschanged(LString const &fil)
{
	bool ret = false;

	if (!fil.empty() && !file.empty() && fil == file) {
		if (new_sum != old_sum && new_sum != 0)
			ret = true;
	}
	if (!ret && next) ret = next->haschanged(fil);
	return ret;
}


void DepTable::write(LString const&f)
{
	FilePtr fp(f, FilePtr::write);
	if (fp() && next) next->write(fp());
}


void DepTable::read(LString const &f)
{
	FilePtr fp(f, FilePtr::read);
	if (fp()) { // file opened
		char nome[256];
		unsigned long one = 0;
		unsigned long two = 0;
		// scan the file line by line
		// return true if the two numbers on the lin eis different
		int ret = 0;
		while (!feof(fp())) {
			ret = fscanf(fp(), "%s %lu %lu",
				     nome, &one, &two);
			if (ret !=3) continue;
			//lyxerr.debug("redep(" + int(ret) + ": " +
			//	      nome + ", " + int(one) +
			//	      " " + int(two));
			insert(LString(nome), one, two);
		}
	}
}


void DepTable::write(FILE *f)
{
	//lyxerr.debug("todep: " + file + " " +
	//	      int(new_sum) + " " + int(old_sum));
	fprintf(f, "%s %lu %lu\n", file.c_str(),
		new_sum, old_sum);
	if (next)
		next->write(f);
}
		
