/*
 * $Id: AskForTextDialog.h,v 1.4 1998/10/22 21:59:09 ettrich Exp $
 */

#ifndef _ASKFORTEXTDIALOG_H
#define _ASKFORTEXTDIALOG_H

#include <qdialog.h>
#include <qstring.h>

class QLabel;
class QLineEdit;

class LyXView;

class AskForTextDialog : public QDialog
{
  Q_OBJECT

public:
  AskForTextDialog ( LyXView* view, QWidget * parent=0, const char * name=0, 
					 WFlags f=0 );

  QString text();
  void setMessage( const char* );
  void setDefault( const char* );
  void setEditFocus();

private slots:
  void okClicked();
  void cancelClicked();

private:
  LyXView* _view;
  
  QLabel* labelLA;
  QLineEdit* editED;
};

#endif

/*
 * $Log: AskForTextDialog.h,v $
 * Revision 1.4  1998/10/22 21:59:09  ettrich
 * fixes for the version control support (thanks to Dimitri Shlyakhtenko)
 *
 * Revision 1.3  1998/06/08 07:18:04  kalle
 * Lots of small changes (edit fields get focus, when they need it, Swedish spelling correction, etc. pp.)
 *
 * Revision 1.2  1998/03/04 21:49:12  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/20 13:11:13  kalle
 * Added forgotten AskForTextDialog
 *
 */
