// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef FINDDIALOG_H
#define FINDDIALOG_H

#include <kdialogbase.h>
#include <qwidget.h>

class KBiblioShell;
class QLineEdit;
class QComboBox;
class QCheckBox;
class BibEntryListView;

class FindWidget : public QWidget
{
    Q_OBJECT
public:	
    FindWidget( KBiblioShell *shell, QWidget *parent, const char *name=0 );
    ~FindWidget();

    
public slots:
    void find();
    void displaySelected( QListViewItem* item );
    void newDocument();

protected:
    bool boolOp( int no, bool b1, bool b2 );
    
    
    
    
private:
    QLineEdit *mLineEdit1;
    QLineEdit *mLineEdit2;
    QLineEdit *mLineEdit3;

    QComboBox *mFieldCombo1;
    QComboBox *mFieldCombo2;
    QComboBox *mFieldCombo3;

    QComboBox *mBoolCombo1;
    QComboBox *mBoolCombo2;

    QCheckBox *mCSBox;
    QCheckBox *mWCBox;
    
    BibEntryListView *mListView;
    QValueList<QDomElement> *mFoundList;
    
    KBiblioShell *mShell;
    QStringList mFieldNames;
};





class FindDialog : public KDialogBase
{
    Q_OBJECT
public:
    FindDialog(	KBiblioShell *shell, QWidget *parent, const char *name=0 );
    ~FindDialog();


private:
    FindWidget *mFindWidget;
};






#endif











