/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/



#include <qstring.h>
#include <stdio.h>


#include "biblined.h"


BibLined::BibLined( QStringList *completionsList, QWidget *parent, const char *name )
    : KLineEdit( parent, name )
{
    mTemplates = completionsList;

    connect( this, SIGNAL( textChanged( const QString &) ), this, SLOT( stopRotation() ) );
    connect( this, SIGNAL( completion() ), this, SLOT( doCompletion() ) );
    connect( this, SIGNAL( rotation() ), this, SLOT( doRotation() ) );
    
    mRotate = false;
    mIgnoreTextChanged = false;
}



BibLined::~BibLined()
{
}


void
BibLined::doCompletion()
{
    mOrigText = text();
    int cpos = cursorPosition();
    mCompBeg = 0;
    mCompLen = cpos;

    QString compString = mOrigText;
    compString.truncate( mCompLen );
    
    setupCompletions( compString );
    
    insertCompletion();
    
    mRotate = true;    
}


void
BibLined::doRotation()
{
    if ( mRotate ){
	insertCompletion();
    }
    else doCompletion();
}


void
BibLined::stopRotation()
{
    if ( !mIgnoreTextChanged )
	mRotate = false;
    else mIgnoreTextChanged = false;
}
    

void
BibLined::setupCompletions( const QString &string )
{
    mCompletions.clear();
    uint length = string.length();
    int index = length-1;
    
    if ( index < 0 )
	mCompletions = *mTemplates;
    else{
	QStringList::ConstIterator it = mTemplates->begin();
	
	for( ; it != mTemplates->end(); ++it ){
	    if ( ( *it ).length() > length ){
		if ( 0 == ( *it ).findRev( string, index ) )
		    mCompletions.append( *it );
	    }
	}
    }
    mNextComp = mCompletions.begin();
}
    

void
BibLined::insertCompletion()
{
    if ( mCompletions.isEmpty() ) return;
    
    QString newText = mOrigText;
    
    newText.replace( mCompBeg, mCompLen, *mNextComp );
    mIgnoreTextChanged = true; 
    setText( newText );
    setCursorPosition( mCompBeg + ( *mNextComp ).length() );
        
    ++mNextComp;
    if ( mNextComp == mCompletions.end() )
	mNextComp = mCompletions.begin();
    
}

#include "biblined.moc"








