/***************************************************************************
                          kashaccount.cpp  -  description
                             -------------------
    begin                : Sun Nov 21 1999
    copyright            : (C) 1999 by Stephan Kahnt
    email                : stephan.kahnt@ipk.fhg.de
 ***************************************************************************/

// standard include
#include <iostream>

// include files for Qt
#include <qdatetime.h>
#include <qmap.h>
#include <qstringlist.h>

// application specific includes
#include "kashaccount.h"
#include "kashtransaction.h"

KashAccount::KashAccount() {
}

KashAccount::KashAccount( const char* aName, const char* aType, 
			  const char* aNo, const char* aDescr ) {
  if ( !aName || !aType ) {
    return;
  }

  name = aName;
  type = aType;

  if ( aNo ) {
    number = aNo;
  }
  else {
    number = "";
  }

  if ( aDescr ) {
    description = aDescr;
  }
  else {
    description = "";
  }

  newIdent = 1;
}

KashAccount::~KashAccount() {
}

void KashAccount::setCurrency( const char* aCurrency ) {
  if ( aCurrency ) {
    currency = aCurrency;
  }
}

long KashAccount::addTransaction( StringVector& dataVec ) {
  if ( transMap.insert( newIdent, KashTransaction( dataVec ) ) ==  transMap.end() ) {
    // insert not ok!
    return 0;
  }
  return newIdent++;
}
  

long KashAccount::addTransaction() {
  transMap.insert( newIdent, KashTransaction() );

  //  cout << transMap.count() << endl;

  return newIdent++;
}
  
bool KashAccount::updateTransaction( long transId, StringVector& dataVec ) {
  if ( !transMap.contains( transId ) ) {
    return false;
  }

  transMap[ transId ] = KashTransaction( dataVec );

  return true;
}

void KashAccount::getTransaction( long transId, StringVector& dataVec ) {
  transMap[ transId ].getTransaction( dataVec );
}

void KashAccount::getIdVector( IdVector& idVec ) {
  TransMapType::Iterator it;
  
  idVec.clear();

  for ( it = transMap.begin(); it != transMap.end(); ++it ) {
    idVec.push_back( it.key() );
  }
}

bool KashAccount::deleteTransaction( long transId ) {
  if ( !transMap.contains( transId ) ) {
    return false;
  }
  
  transMap.remove( transId );

  //  cout << transMap.count() << endl;

  return true;
}

void operator << ( QTextStream& s, KashAccount& account ) {

  if ( ! account.type.isEmpty() ) {
    s << "!Type:" << account.type << endl;
  }
  
  KashAccount::TransMapType::Iterator transIt;
  
  for ( transIt = account.transMap.begin();
        transIt !=  account.transMap.end();
        ++transIt ) {
    //    transIt.data().save( s );
    s << transIt.data();
  }         
}

bool operator >> ( QTextStream& s, KashAccount& account ) {
  char ch;
  QString keyName;
  KashAccount::TransMapType::Iterator it;

  s >> ch;
  if ( ch == '!' ) {
    s >> ch;
    while ( ch != ':' && ch != '\n' ) { 
      keyName += ch;
      s >> ch;
    }
    if ( keyName == "Type" ) {
      account.type = s.readLine();
    }
    else {
      s.readLine();
    }
  }

  StringVector dummy;
  while ( ! s.atEnd() ) {
    it = account.transMap.insert( account.newIdent, KashTransaction() );
    //    cout << account.transMap.count() << endl;
    if ( s >> it.data() ) {
      it.data().getTransaction( dummy );
      emit account.sigNewTransaction( account.newIdent, dummy );
      account.newIdent++;
    }
    else {
      account.transMap.remove( it );
    }
  }

  return true;
}
















