/* This is a simple test program that tries basic I/O
 * functionality and reports any error that occured.
 * 
 * the Configuration Database library, Version II
 * copyright:  (C) Mirko Sucker, 1998 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4, STL
 * $Revision: 1.3 $
 */

#include "qconfigDB.h"
#include <iostream.h>
#include <qapp.h>

int main(int argc, char** argv)
{
  // ###########################################################################
  QApplication qapp(argc, argv);
  cerr << "Test for creating, reading, writing, searching and "
       << "clearing databases." << endl
       << "Please mail any failures that occure to " << endl
       << "    Mirko Sucker <mirko.sucker@unibw-hamburg.de>"
       << endl << "including some information on how to reproduce the error. " 
       << endl 
       << "Thank you in advance,             Mirko." << endl
       << "-------------------" << endl;
  QConfigDB db;
  const char* Sections[]= 
  { 
    "A/B",
    "A/C",
    "A/B/D",
    "A/B/E" 
  };
  unsigned int index;
  const unsigned int Size=(sizeof(Sections)/sizeof(Sections[0]));
  KeyValueMap* keys;
  // -----
  for(index=0; index<Size; index++)
    {
      if(!db.createSection(Sections[index]))
 	{
 	  cerr << "Error creating section " << Sections[index] 
	       << endl;
 	  return -1;
 	}
    }
  if(!db.get("A/B/D", keys))
    {
      cerr << "ERROR: cannot not find section that was created "
	   << "immidiately before!" << endl;
      return -1;
    }
  if(!keys->insert("key_1", "0.1") 
     || 
     !keys->insert("key_2", "this is a string"))
    {
      cerr << "ERROR: could not insert keys into empty section!"
	   << endl;
      return -2;
    }
  if(!db.get("A/B/E", keys))
    {
      cerr << "ERROR: cannot not find section that was created "
	   << "immidiately before!" << endl;
      return -3;
    }
  if(!keys->insert("key_1", "0.2")
     ||
     !keys->insert("key_2", 
		   "this is another string in another section"))
    {
      cerr << "ERROR: could not insert keys into empty section!"
	   << endl;
      return -4;
    }
  if(!keys->erase("key_1"))
    {
      cerr << "ERROR: could not erase previously added key-value-pair."
	   << endl;
      return -5;
    }
  keys=db.get();// get top level section, MUST work
  if(!keys->insert("key_1", "0.3") 
     ||
     !keys->insert("key_2", 
		   "this is a string in the toplevel section"))
    {
      cerr << "ERROR: could not insert keys into top "
	   << "level section!" << endl;
      return -6;
    }
  if(!db.setFileName("database", false))
    {
      cerr << "ERROR: unable to set database filename to "
	   << "\"database\" (no writing permissions?)." << endl;
      return -6;
    }
  if(!db.save())
    {
      cerr << "ERROR: cannot save database file." << endl;
      return -7;
    }
  if(!db.clear())
    {
      cerr << "ERROR: cannot erase database contents." << endl;
      return -8;
    }
  if(!db.load()) 
    {
      cerr << "ERROR: cannot reload previously saved database file."
	   << endl;
      return -9;
    }
  if(!db.setFileName("database-2", false)) 
    {
       cerr << "ERROR: unable to set database filename to "
	   << "\"database-2\"." << endl
	   << "(may be denied permission to write)" << endl;     
      return -10;
    }
  if(!db.save())
    {
      cerr << "ERROR: cannot save database file." << endl;
      return -11;
    }
  cerr << "SUCCESS: no failures during database operations."
       << endl;
  return 0;
  // ###########################################################################
}
