/***************************************************************************
                          resource.h  -  description                              
                             -------------------                                         
    begin                : Tue Jun  8 20:40:39 /etc/localtime 1999
                                           
    copyright            : (C) 1999 by Roberto Alsina                         
    email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <pth.h>

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands


///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES


///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_NEW_WINDOW          10010
#define ID_FILE_NEW                 10020
#define ID_FILE_OPEN                10030

#define ID_FILE_SAVE                10050
#define ID_FILE_SAVE_AS             10060
#define ID_FILE_CLOSE               10070

#define ID_FILE_PRINT               10080

#define ID_FILE_CLOSE_WINDOW        10090
#define ID_FILE_QUIT                10100

#define ID_GET_ACTIVE		    20000
#define ID_NEW_SERVER		    20001
#define ID_ONLINE                   20002
#define ID_DELETE_SERVER            20003
#define ID_SERVER_PROPERTIES        20004
#define ID_SERVER_OPEN              20005
#define ID_ADD_GROUP                20006
#define ID_STOP_CONN                20007
#define ID_ABORT_CONN               20008
#define ID_CLOSE_CONN               20008
#define ID_SERVER_CLOSE             20009
#define ID_GROUP_OPEN               20010
#define ID_GET_HEADERS              20011
#define ID_GET_FAQ                  20012
#define DEJA_SEE_ARTICLE            20012
#define DEJA_SEE_THREAD             20013
#define DEJA_REPLY                  20014
#define DEJA_FETCH_ARTICLE          20015
#define MARK_ARTICLE_READ	          20016
#define MARK_ARTICLE_UNREAD         20017
#define ID_NEW_FOLDER	              20018
#define ID_REMOVE_FOLDER            20019
#define ID_OPEN_FOLDER	            20020
#define ID_CLOSE_FOLDER	            20021
#define SAVE_ARTICLE  	            20022
#define ID_GROUP_SUBSCRIBE          20023


///////////////////////////////////////////////////////////////////
// Edit-menu entries
#define ID_EDIT_UNDO                11010
#define ID_EDIT_REDO                11020
#define ID_EDIT_COPY                11030
#define ID_EDIT_CUT                 11040
#define ID_EDIT_PASTE               11050
#define ID_EDIT_SELECT_ALL          11060


///////////////////////////////////////////////////////////////////
// View-menu entries
#define ID_VIEW_TOOLBAR             12010
#define ID_VIEW_STATUSBAR           12020
#define ID_VIEW_OPTIONS             12030

///////////////////////////////////////////////////////////////////
// Help-menu entries
#define ID_HELP                     1002

///////////////////////////////////////////////////////////////////
// General application values
#define ID_STATUS_MSG               1001

#define IDS_DEFAULT                 "Ready."

#define IDS_APP_ABOUT               "NewKrn\nVersion " VERSION



///////////////////////////////////////////////////////////////////
// MACROS FOR THE CONNECT OF YOUR SIGNALS TO CORRESPONDENT SLOTS
// IN YOUR MAIN IMPLEMENTATION OF MENUBAR AND TOOLBAR


///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));connect(submenu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)))


///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));connect(ToolBar, SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)))

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)   case id:cmd_class_function ;break;

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;

///////////////////////////////////////////////////////////////////
// Global stuff

class ConnMgr;
extern ConnMgr *connmgr;
extern pth_attr_t attr;

const long TooManyThreshold=100;
#endif // RESOURCE_H












