/***************************************************************************
 groupreader.cpp  -  description                              
 -------------------                                         
 begin                : Sun Jun 13 1999                                           
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "groupreader.h"
#include "serversroot.h"
#include "basegroup.h"
#include "kfileio.h"
#include "newkrndoc.h"
#include "resource.h"
#include "util.h"
#include "dirtreepopup.h"

#include <qsplitter.h>
#include <qpopupmenu.h>
#include <qlistview.h>
#include <qlayout.h>
#include "kmail/kmreaderwin.h"
#include <kurl.h>
#include <kapp.h>
#include <kfm.h>
#include <kiconloader.h>
#include <pth.h>

QPixmap *THR_PIXMAP=0;
QPixmap *MSG_PIXMAP=0;

GroupReader::GroupReader(QWidget *parent, NewKrnDoc *_doc) :QSplitter(parent)
{
    setOpaqueResize(true);
    setOrientation(QSplitter::Vertical);
    artList=new QListView (this);
    artList->setFocusPolicy(QWidget::StrongFocus);
    artList->setAllColumnsShowFocus(true);
    artList->addColumn("Subject");
    artList->addColumn("R");
    artList->addColumn("From");
    artList->addColumn("Lines");
    artList->setRootIsDecorated(true);
    body=new KMReaderWin (this);
    show();
    setMinimumWidth(.75*parent->width());
    qApp->processEvents();
    setMinimumWidth(0);
    doc=_doc;
    connect (artList,SIGNAL(currentChanged(QListViewItem *)),this,SLOT(openArticle(QListViewItem *)));
    connect (artList,SIGNAL(rightButtonClicked(QListViewItem *,const QPoint &, int)),this,SLOT(rightClicked(QListViewItem *)));
}
GroupReader::~GroupReader()
{
    delete group;
}

int counter=0;

void GroupReader::insertArtTree(ArtTreeNode *root,ArticleItem *parent)
{
    static QString lastSubj="";
    static ArticleItem *lastThreadHead=0;
    ArticleItem *item;
    if (root->art) //has an article
    {
        if (parent)
        {
            item=new ArticleItem(parent,root->art->ID);
            counter++;
            parent->setExpandable(true);
        }
        else
        {
            if (lastSubj!=root->subject) // new  thread
            {
                lastThreadHead=new ArticleItem(artList,"");
                if (!THR_PIXMAP)
                    THR_PIXMAP=new QPixmap(ICON("thread.xpm"));
                lastThreadHead->setPixmap(0,*THR_PIXMAP);
                lastThreadHead->setText(0,root->subject);
                lastSubj=root->subject;
                item=new ArticleItem(lastThreadHead,root->art->ID);
                counter++;
            }
            else //Not really new thread
            {
                item=new ArticleItem(lastThreadHead,root->art->ID);
                counter++;
            }
        }
        item->setText(0,root->art->Subject);
        if (!MSG_PIXMAP)
            MSG_PIXMAP=new QPixmap(ICON("followup.xpm"));
        item->setPixmap(0,*MSG_PIXMAP);
        if (root->art->Read)
            item->setText(1,"X");
        item->setText(2,root->art->From);
        item->setText(3,QString().sprintf("%8d",root->art->Lines));
        QListIterator <ArtTreeNode> it(root->children);
        for (;it.current();++it)
        {
            insertArtTree(it.current(),item);
            pth_yield(NULL);
        }
    }
    else //has no article
    {
        QListIterator <ArtTreeNode> it(root->children);
        for (;it.current();++it)
        {
            insertArtTree(it.current());
            pth_yield(NULL);
        }
    }
}


void GroupReader::setGroup(BaseGroup *_group)
{
    debug ("entered GroupReader::setGroup");
    artList->clear();
    list.clear();
    group=_group;
    group->list(list);
    //Unthreaded version

    QListIterator <Article> it(list);
    for (;it.current();++it)
    {
        ArticleItem *i=new ArticleItem(artList,it.current()->ID);
        i->setText(0,it.current()->Subject);
        if (it.current()->Read)
            i->setText(1,"X");
        i->setText(2,it.current()->From);
        i->setText(3,QString().sprintf("%8d",it.current()->Lines));
        pth_yield(NULL);
    }

    //Threaded version
/*
    debug ("flag0");
    ArtTreeNodeList *treebase=list.threaded();
    debug ("flag1");
    
    QListIterator <ArtTreeNode> it(*treebase);
    for (it.toFirst();it.current();++it)
    {
        debug ("loop");
//        debug ("subj->%s",it.current()->subject.data());
        insertArtTree(it.current());
        pth_yield(NULL);
        }
*/
    debug ("counter %d",counter);



    //FIXME this should be configurable
    //		doc->downloadArticles(group,list);
    debug ("leaving GroupReader::setGroup");
}



void GroupReader::openArticle (QListViewItem *_item)
{
    ArticleItem *item=(ArticleItem *)_item;
    if (item->isBusy())
        return;
    item->busy();
    if (item->ID.isEmpty()) //It's a thread header
    {
//        item->setOpen(true);
//        qApp->processEvents();
//        artList->setCurrentItem(item->firstChild());
//        openArticle(item->firstChild());
        item->idle();
        return;
    }
    doc->showArticle(group,item,item->ID,body);
    item->setText(1,"X");
    artList->setSelected(item,true);
    doc->setRead(item->ID,true);
    item->idle();
}

void GroupReader::rightClicked(QListViewItem *i)
{
    ArticleItem *item=( ArticleItem *)i;
    QPopupMenu *popup=new QPopupMenu (0);
    QPopupMenu *deja=new QPopupMenu (0);
    DirTreePopup *save=new DirTreePopup(KApplication::localkdedir()+"/share/apps/newkrn/Folders",false);
    popup->insertItem("Save", save);
    if (!strncmp(item->text(1),"X",1))
        popup->insertItem("Mark as unread",MARK_ARTICLE_UNREAD);
    else
        popup->insertItem("Mark as read",MARK_ARTICLE_READ);
    popup->insertItem("Deja.com", deja);
    deja->insertItem("Lookup in Deja.com", DEJA_SEE_ARTICLE);
    deja->insertItem("Get from Deja.com", DEJA_FETCH_ARTICLE);
    deja->insertItem("Reply through Deja.com", DEJA_REPLY);
    connect (deja,SIGNAL(activated(int)),popup,SIGNAL(activated(int)));
    int res=popup->exec(QCursor::pos());
    debug ("res-->%d",res);
    if (res==-1)
        return;
    switch (res)
    {
    case  DEJA_SEE_ARTICLE:
        {
            KURL kurl("http://www.deja.com/=dnc/msgid.xp?MID="+item->ID);
            KFM *kfm=new KFM;
            kfm->openURL(kurl.url());
            delete kfm;
            break;
        }
    case  DEJA_FETCH_ARTICLE:
        {
            item->busy();
            QString path=KApplication::localkdedir()+"/share/apps/newkrn/cache/"+item->ID;
            KURL kurl("http://www.deja.com/=dnc/msgid.xp?MID="+item->ID+"&fmt=text");
            KFM *kfm=new KFM;
            kfm->download(kurl.url(),path);
            delete kfm;
            artList->setCurrentItem(item);
            //            openArticle(item);
            item->idle();
            break;
        }
    case  DEJA_REPLY:
        {
            notImplemented();
            break;
        }
    case MARK_ARTICLE_UNREAD:
        {
            doc->setRead(item->ID,false);
            item->setText(1," ");
            break;
        }
    case MARK_ARTICLE_READ:
        {
            doc->setRead(item->ID,true);
            item->setText(1,"X");
            break;
        }
    default:
        {
            notImplemented();
            break;
        }

    }
}





