#ifndef _KXICQ_MESSAGE_H
#define _KXICQ_MESSAGE_H

#define BUFSIZE 1024
#define UIN unsigned int

#include <qstring.h>
#include <qfile.h>
#include "kxicq.h"

#define FILE_ERROR 1
#define FILE_NONE 0
#define FILE_OPEN 2

class MSG;

struct MSGf
{
    UIN uin;
    int type;
    int online;
    int status;
    TIME time;

    UIN len;
    
    char *message;
    char *url;
    char *nick;
    char *firstName;
    char *lastName;
    char *email;
    char *authText;

    int auth_req;
    int auth;
};
        

class ReadFile
{
public:
    ReadFile(char *);
    ReadFile();
    ~ReadFile();

    void setFileName(char *);
    
    int scanMessages();
    void readMessage(UIN, MSGf *);

    void setRead(UIN,int);
    int getStatus();

private:
    int status;
    QFile file;
    int count;
};

class MSG
{
public:
    MSG(UIN);
    MSG();
    ~MSG();

    void setUin(UIN);
    void setMessage(MSGf *);
    void setPos(int);
    void setStatus(int);
    void setnRead(int r) { read=r; };
    void setRead(int);
    

    UIN getUin() { return uin; };
    void getMessage(MSGf *);
    int getPos() { return pos; };
    int getStatus() { return status; };
    int getRead() { return read; };
    

private:
    int read;
    UIN uin;
    int pos;
    int status;
    QString message;
};

    
#endif
