/**************************************************************************
* libXicq - Originally written by tnc (xtrophy@it.dk)                     *
*'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
* contact.h                                                               *
* Handles the contact list                                                *
**************************************************************************/


#ifndef _CONTACT_H
#define _CONTACT_H


#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "config.h"
#include "structs.h"
#include "misc.h"


int contact_init( char *contactPath );
int	contact_save( char *contactPath );
int contact_length();
CONTACT contact_returnItemNum( int num );
char *contact_uin2nick( unsigned int uin );
int contact_isuin( unsigned int uin );
unsigned int contact_nick2uin( char *nick );
CONTACT contact_returnContact( unsigned int uin );
int contact_updateContact( CONTACT update_contact );
char *contact_status2str( int status );
int contact_deleteContact( UIN uin );
int contact_renameContact( UIN uin, const char *nick );
int contact_add( const char *nick, UIN uin );
char *getawaymsg();
void setawaymsg( char *msg );
void *contact_getClas( UIN uin );
void contact_insertClas( UIN uin, void *clas );


#endif


