/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* urlitem.h */

#ifndef URLITEM_H_INCLUDED
#define URLITEM_H_INCLUDED

#include "/usr/include/ndbm.h"
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <qdatetm.h>

#include "mainwidget.h"

#define INITIAL_LAST_MODIFIED "Mon, 01 Jan 1990 00:00:00 GMT"

#define NOT_YET_CHECKED  0
#define NO_CHANGE        1
#define UPDATE_FOUND     2
#define CONNECT_FAILED   3
#define NO_DATE_PROVIDED 4 
#define UPDATE_READ      5
#define URL_SYNTAX_ERROR 6
#define URL_NOT_FOUND    7
#define CHECK_NOT_NEEDED 8
#define URL_MOVED        9
#define UNKNOWN_ERROR    10

#define URL_LEN             300
#define ALIAS_LEN           50
#define LAST_TIME_LEN       30
#define NEXT_TIME_LEN       30
#define HOW_OFTEN_LEN       30
#define LAST_MODIFIED_LEN   30
#define BROWSER_PATH_LEN    300
#define PROXY_ADDR_LEN      50

#define HOST_LEN            50
#define REMOTE_FILE_LEN     250


// Structure used for moving data into the dbm database
struct url_data
{
    char  url[URL_LEN];
    char  alias[ALIAS_LEN];
    char  last_time[LAST_TIME_LEN];
    char  next_time[NEXT_TIME_LEN];
    char  how_often[HOW_OFTEN_LEN];
    int	  result;
    char  last_modified[LAST_MODIFIED_LEN];
    long  size;
    bool  use_default_browser;
    char  browser_path[BROWSER_PATH_LEN];
    bool  best_guess;
    bool  skip_tags;
};


class UrlItem
{
 private:	
    char       m_Url[URL_LEN];
    char       m_Alias[ALIAS_LEN];
    char       m_HowOften[HOW_OFTEN_LEN];
    char       m_LastTime[LAST_TIME_LEN];
    QDateTime* m_pNextTime;
 
    int	       m_Result;
    char       m_LastModified[LAST_MODIFIED_LEN];
    long       m_Size;
    bool       m_UseDefaultBrowser;
    char       m_BrowserPath[BROWSER_PATH_LEN];
    bool       m_BestGuess;
    bool       m_SkipTags;
   
    char       m_Host[HOST_LEN];
    char       m_Fname[REMOTE_FILE_LEN];
    char*      m_OldUrl;
  
 public:
	
    UrlItem(); 
	
    UrlItem( const char* alias, const char* url, const char* how,
	     bool use_default_browser, const char* browser_path = 0,
	     bool best_guess = 0, bool skip_tags = 0,
	     const char* last = 0, QDateTime* pDateTime = 0,
	     int result = 0, const char* last_modifed = 0,
	     long size = 0);
	
    ~UrlItem();
	
		
    int  WriteToDisk();
    void ParseUrl();
    bool LookForLastModifiedDate( char* server_text );
    bool FileBodyLengthChanged( int fd, char* server_text );
    bool LengthNotCountingTagsChanged( int fd, char* server_text );
    void UpdateNextTime();
    void UpdateLastTime();
	            
    const char* GetUrl(){ return m_Url; };
    const char* GetAlias(){ return m_Alias; };
    const char* GetBrowserPath(){ return m_BrowserPath; };
    const char* GetHowOften( ){ return m_HowOften; };
    const char* GetLastTime( ){ return m_LastTime; };
    QDateTime* GetNextTime( ){ return m_pNextTime; };
    int GetResult(){ return m_Result; };
    const char* GetLastModified() {return m_LastModified; };
    long GetSize(){ return m_Size; };
    const char* GetHost(){ return m_Host; };
    const char* GetFname(){ return m_Fname; };
    bool UsingDefaultBrowser(){ return m_UseDefaultBrowser; };
    bool UsingBestGuess(){ return m_BestGuess; };
    bool SkippingTags(){ return m_SkipTags; };
    const char* GetOldUrl(){ return m_OldUrl; };

    void SetUsingDefaultBrowser( bool flag ){ m_UseDefaultBrowser = flag; };
    void SetUrl( const char* Url ){ strcpy( m_Url, Url );};
    void SetAlias( const char* Alias ){ strcpy( m_Alias, Alias );};
    void SetBrowserPath( const char* path ){ strcpy( m_BrowserPath, path );};
    void SetHowOften( const char* HowOften ){ strcpy( m_HowOften, HowOften );};	
    void SetLastTime( const char* LastTime ){ strcpy( m_LastTime, LastTime );};
    void SetNextTime( QDateTime* pNextTime ){ m_pNextTime = pNextTime;};
    void SetResult( int Result ){ m_Result = Result; };
    void SetLastModified( const char* LastMod ){ strcpy(m_LastModified,
							LastMod );};
    void SetSize( long size ){ m_Size = size; };
    void SetBestGuess( bool flag ){ m_BestGuess = flag; };
    void SetSkipTags( bool flag ){ m_SkipTags = flag; };
    void SetOldUrl( const char* Url );
	
}; 

#endif // URLITEM_H_INCLUDED
