/***************************************************************************
                          ksmsdoc.cpp  -  description
                             -------------------
    begin                : Mon Sep 20 20:07:18 MEST 1999
    copyright            : (C) 1999 by Olaf Loesken
    email                : oloesken@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>





// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include <ksmsdoc.h>
#include "ksms.h"
#include "ksmsview.h"

QList<KSMSView>* KSMSDoc::viewList = 0L;

KSMSDoc::KSMSDoc(QWidget *parent, const char* name):QObject(parent, name)
{
	if( !viewList )
		viewList = new QList<KSMSView>;
	viewList->setAutoDelete(true);
}

KSMSDoc::~KSMSDoc()
{
}

void KSMSDoc::addView(KSMSView* m_pView)
{
	viewList->append(m_pView);
}

void KSMSDoc::removeView(KSMSView* m_pView)
{
	viewList->remove(m_pView);
}
const QString& KSMSDoc::getPathName() const
{
	return m_path;
}

void KSMSDoc::slotUpdateAllViews(KSMSView* pSender)
{
	KSMSView* w;
	if(viewList)
	{
		for( w = viewList->first(); w; w = viewList->next() )
		{ if( w != pSender)
				w->repaint();
		}
	}

}

void KSMSDoc::pathName( const char* path_name)
{
	m_path=path_name;
}
void KSMSDoc::title( const char* title)
{
	m_title=title;
}

const QString& KSMSDoc::getTitle() const
{
	return m_title;
}

bool KSMSDoc::saveModified()
{
	if(b_modified)
	{
		KSMSApp* win=(KSMSApp*) parent();
  	int want_save = KMsgBox::yesNoCancel(win,
  									i18n("Warning"),	i18n("The current file has been modified.\nDo you want to save it?"));
   	switch(want_save)
    {
    	case 1:
    		if(m_title == "Untitled")
    			win->slotFileSaveAs();
    		else
	     		saveDocument(getPathName()+getTitle());
       	
       	deleteContents();
        return true;
        break;
  		case 2:
    		setModified(false);
      	deleteContents();
  			return true;
  			break;	
  		case 3:
  			return false;
  			break;
  		default:
  			return false;
  			break;
  	}
	}
	else
		return true;

}

void KSMSDoc::closeDocument()
{
	deleteContents();
}

bool KSMSDoc::newDocument()
{
	
	/////////////////////////////////////////////////
	// TODO: Add your document initialization code here
	/////////////////////////////////////////////////
	b_modified=false;
	m_path=QDir::homeDirPath();
	m_title="Untitled";
	return true;
}

bool KSMSDoc::openDocument(const char* filename, const char* format)
{
	QFileInfo fileInfo(filename);
	m_title=fileInfo.fileName();
	m_path=fileInfo.absFilePath();	
	/////////////////////////////////////////////////
	// TODO: Add your document opening code here
	/////////////////////////////////////////////////
	
	b_modified=false;
	return true;
}

bool KSMSDoc::saveDocument(const char* filename, const char* format)
{

	/////////////////////////////////////////////////
	// TODO: Add your document saving code here
	/////////////////////////////////////////////////

	b_modified=false;
	return true;
}

void KSMSDoc::deleteContents()
{
	/////////////////////////////////////////////////
	// TODO: Add implementation to delete the document contents
	/////////////////////////////////////////////////

}





































