#ifndef _KDICTLIST_H
#define _KDICTLIST_H

#include <qobject.h>
#include <qdict.h>
#include <kconfig.h>
#include "kgdictlist.h"

template < class Type2 >
class KDictList : public KGDictList {
public:
  KDictList ( QDictIteratorT<Type2> * aIter ) : 
    KGDictList ( (KGDictIterator *) aIter ) {};
    
  KDictList ( Type2 * aIter ) : 
    KGDictList ( (QGDict *) aIter ) {};
  
  ~KDictList() {};
  
  // the next functions work like a QList.
  
  const char * next()	{return KGDictList::next();}
  const char * prev()	{return KGDictList::prev();}
  const char * first()	{return KGDictList::first();}
  const char * last()	{return KGDictList::last();}
  const char * current()	{return KGDictList::current();}
};


typedef KDictList<KEntryDict>		KGroupList;
typedef KDictList<KEntryDictEntry>	KEntryList;

#endif

