//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This file os part of KRN, a newsreader for the KDE project.              //
// KRN is distributed under the GNU General Public License.                 //
// Read the acompanying file COPYING for more info.                         //
//                                                                          //
// KRN wouldn't be possible without these libraries, whose authors have     //
// made free to use on non-commercial software:                             //
//                                                                          //
// MIME++ by Doug Sauder                                                    //
// Qt     by Troll Tech                                                     //
//                                                                          //
// This file is copyright 1997 by                                           //
// Roberto Alsina <ralsina@unl.edu.ar>                                      //
// Magnus Reftel  <d96reftl@dtek.chalmers.se>                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#include <stdlib.h>

#include "NNTP.h"
#include <qstrlist.h>
#include <qlist.h>
#include <qbuffer.h>
#include <qapp.h>
#include <qlistview.h>
#include <ksimpleconfig.h>

#include <mimelib/mimepp.h>

#include <assert.h>
#include <unistd.h>

#include "article.h"
#include "articleitem.h"
#include "rules.h"
#include "artdlg.h"
#include "kfileio.h"

extern QString cachepath,artinfopath,groupinfopath;//krnpath

int k1;
int k2;
int k3;
int k4;
void QStringSplit (const QString &data,char sep,QStrList &splitted);
extern bool strictdelete;


////////////////////////////////////////////////////////////////////
// NewsGroup class. Represents a newsgroup
// Real docs soon.
////////////////////////////////////////////////////////////////////


NewsGroup::NewsGroup(const char *_name)
{
    artList.setAutoDelete(true);
    isVisible=0;
    sconf=0;
    name=qstrdup(_name);
    dirty=false;
}


NewsGroup::~NewsGroup()
{
    if (sconf)
    {
        save();
        delete sconf;
    }
    free (name);
}

void NewsGroup::getList(const char *extracond)
{
    debug ("entered getlist");
    QString ID;
    QString status;
    QString s;

    if (extracond)
    {
        s.sprintf ("%s and (%s)",genQuery().data(),extracond);
    }
    else
    {
        s=genQuery();
    }

    dbCursor <Article> *cursor=new dbCursor <Article>;
    dbQuery q(s.data());

    debug ("making query:\n%s\n12345678901234567890123456789012345678901234567890123456789012345678901234567890\n",s.data());
    strictdelete=false;
    if (cursor->select(s.data()))
    {
        debug ("Traversing results");
        Article *art=cursor->first();
        while (art)
        {
            artList.append(new Article (art));
            art=cursor->next();
        }
        status.sprintf ("Received %d articles",artList.count());
        debug ("%s",status.data());
    }
    debug ("query returned %d things!",cursor->getNumberOfRecords());
    strictdelete=true;
    cursor->reset();
    strictdelete=false;
    delete cursor;
    strictdelete=true;

    debug ("left getlist(3)");
}

void NewsGroup::updateList()
{
}

void NewsGroup::save()
{
}

void NewsGroup::load()
{
}

int NewsGroup::lastArticle(NNTP &server)
{
    QString p=groupinfopath+name;
    if (!sconf)
    {
        QString q=p+".conf";
        sconf=new KSimpleConfig(q);
    }
    sconf->setGroup(server.hostname.data());
    return sconf->readNumEntry("LastArticle",0);

}

void NewsGroup::saveLastArticle(NNTP &server,int i)
{
    QString p=groupinfopath+name;
    if (!sconf)
    {
        QString q=p+".conf";
        sconf=new KSimpleConfig(q);
    }
    sconf->setGroup(server.hostname.data());
    sconf->writeEntry("LastArticle",i);
    sconf->sync();

}

void NewsGroup::getSubjects(NNTP &server)
{
    debug ("entered newsgroup::getSubjects");
    server.setGroup(name);
    if (server.last>lastArticle(server))
    {
        debug ("xover from %d to %d",lastArticle(server)+1,server.last+5);
        server.artList(lastArticle(server)+1,server.last,this);
        save();
    }
    debug ("left newsgroup::getSubjects");
}

void NewsGroup::getMessages(NNTP &server)
{
    debug ("getting articles in %s",name);
    load();
    getSubjects(server);
    getList();
    server.resetCounters (true,true);
    server.reportCounters (false,true);
    for (Article *art=artList.first();art!=0;art=artList.next())
    {
        if (!(server.isCached(art->ID)&PART_ALL))
        {
            QString s;
            server.article(art->ID,s);
        }
        qApp->processEvents();
    }
    server.resetCounters (true,true);
    server.reportCounters (true,false);
}

void NewsGroup::getTaggedMessages(NNTP &server)
{
    debug ("getting articles in %s",name);
    load();
    getSubjects(server);
    getList();
    server.resetCounters (true,true);
    server.reportCounters (false,true);
    for (Article *art=artList.first();art!=0;art=artList.next())
    {
        qApp->processEvents();
        if (!(art->ismarked))
            continue;
        if (!(server.isCached(art->ID)&PART_ALL))
        {
            QString s;
            server.article(art->ID,s);
        }
    }
    server.resetCounters (true,true);
    server.reportCounters (true,false);
}
void NewsGroup::catchup()
{
    debug ("catching up");
    getList();
    int count=0;
    for (Article *art=artList.first();art!=0;art=artList.next())
    {
        count++;
        if (!art->isread)
        {
            art->setRead();
            if (!(count%5))
            {
                qApp->processEvents();
            }
        }
    }
}

int NewsGroup::countNew(NNTP &server)
{
    int count = 0;
#warning make this do a query instead of doing getlist
    getList();

    bool s=false;
    if (server.isConnected())
    {
        if(strcmp(server.group(), name))
            s=server.setGroup(name);
        if (s)
        {
            if(server.last > lastArticle(server))
                count = server.last - lastArticle(server);
        }
    }
    for(Article *art=artList.first(); art!=0; art=artList.next())
        if(!art->isread)
            count++;
    artList.clear();
    return(count);
}

QString NewsGroup::genQuery()
{
    QString s;
    s.sprintf("exists i:(groups[i].name = '%s')",name);
    return s;
}


////////////////////////////////////////////////////////////////////
// GroupList class. Represents a list of newsgroup
// Real docs soon.
////////////////////////////////////////////////////////////////////


GroupList::GroupList()
{
    setAutoDelete(true);
}

GroupList::~GroupList()
{
}
int GroupList::compareItems(GCI item1,GCI item2)
{
    return strcmp(((NewsGroup *)item1)->name,((NewsGroup *)item2)->name);
}

void insertArtTree(ArtTreeNode *root,QListViewItem *parent,QListView *list)
{
    QListViewItem *item;
    if (root->art) //has an article
    {
        if (parent)
        {
            item=root->art->item(parent);
            parent->setExpandable(true);
        }
        else
        {
            item=root->art->item(list);
        }
    }
    else //no article
    {
        item=new ThreadItem(list,root->subject);
    }

    QListIterator <ArtTreeNode> it(root->children);
    for (;it.current();++it)
    {
        insertArtTree(it.current(),item,list);
    }
}

