#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include "article.h"

#include <gdbm.h>
GDBM_FILE artdb;
GDBM_FILE refsdb;
GDBM_FILE scoredb;

#include "gigabase/gigabase.h"
//Gigabase Article class
dbDatabase db (dbDatabase::dbAllAccess,0,dbDefaultExtensionQuantum,
              4096);

dbCursor <Article> cursor(dbCursorForUpdate);

#include <mimelib/mimepp.h>

char *emptystr="";

#define KRNCONVERT
bool strictdelete=true;
#include "article.cpp"

int Article::score()
{
    return 0;
}
bool Article::cached()
{
    return false;
}

int main (int argc, char **argv)
{
    try
    {
        char *path=(char *)malloc(4096);
        printf ("Opening GDBM databases\n");
        strcpy(path,getenv("HOME"));
        strcat (path,"/.kde/share/apps/krn/refs.db");
        printf ("Opening %s\n",path);
        refsdb=gdbm_open(path,0,GDBM_READER,0,0);
        if (!refsdb)
        {
            printf ("Error opening refs database!\n"
                    "Sorry, I don't know what to do.\n");
            throw(1);
        }
        strcpy(path,getenv("HOME"));
        strcat (path,"/.kde/share/apps/krn/artinfo.db");
        printf ("Opening %s\n",path);
        artdb=gdbm_open(path,0,GDBM_READER,0,0);
        if (!artdb)
        {
            printf ("Error opening articles database!\n"
                    "Sorry, I don't know what to do.\n");
            throw(1);
        }
        strcpy(path,getenv("HOME"));
        strcat (path,"/.kde/share/apps/krn/scores.db");
        printf ("Opening %s\n",path);
        scoredb=gdbm_open(path,0,GDBM_READER,0,0);
        if (!scoredb)
        {
            printf ("Error opening scores database!\n"
                    "Sorry, I don't know what to do.\n");
            throw(1);
        }

        strcpy(path,getenv("HOME"));
        strcat (path,"/.kde/share/apps/krn/articles.dbs");
        printf ("Opening GigaBase database %s.\n",path);
        int res=db.open(path);
        if (!res)
        {
            printf ("Error opening Gigabase!\n");
            throw(2);
        }

        //Start reading the articles
        datum key=gdbm_firstkey ( artdb );
        datum nextkey;
        datum refs;
        datum score;
        datum realkey;
        datum artinfo;

        printf ("Reading Articles from GDBM databases\n");
        int counter=0;
        int readc=0;
        int unreadc=0;
        int refc=0;
        int scorec=0;
        int expirec=0;
        int ismarkedc=0;
        Article art;
        while ( key.dptr )
        {
            if (!(counter%50))
            {
                printf ("# %d\n",counter);
            }
            counter++;
            if (key.dptr[0]=='R')
            {
                art.ID=key.dptr+1;
                art.isread=true;
                readc++;
                realkey.dptr=key.dptr+1;
                realkey.dsize=key.dsize-1;
            }
            else
            {
                art.ID=key.dptr;
                art.isread=false;
                unreadc++;
                realkey.dptr=key.dptr;
                realkey.dsize=key.dsize;
            }

            artinfo=gdbm_fetch(artdb,key);
            {
                char *tok= strtok (artinfo.dptr,"\n");
                art.Subject=tok;
                tok=strtok(NULL,"\n");
                tok=strtok(NULL,"\n");
                art.Lines=atoi(tok);
                tok=strtok(NULL,"\n");
                art.From=tok;

                tok=strtok(NULL,"\n");
                DwDateTime date;
                date.FromString(DwString(tok));
                date.Parse();
                art.Date=dbDateTime((time_t)date.AsUnixTime());
                if (art.Date.stamp==-1)
                    fprintf (stderr,"Invalid date on gdbm?\n");

                tok=strtok(NULL,"\n");
                art.desperate=tok;
                tok=strtok(NULL,"\n");
                tok=strtok(NULL,"\n");
                if (*tok=='1')
                {
                    art.expire=true;
                    expirec++;
                }
                else
                {
                    art.expire=false;
                }
                tok=strtok(NULL,"\n");
                if (*tok=='1')
                {
                    art.ismarked=true;
                    ismarkedc++;
                }
                else
                {
                    art.ismarked=false;
                }
            }

            refs=gdbm_fetch(refsdb,realkey);
            char *tmpstr=(char *)malloc(8192);
            if (refs.dptr && refs.dsize>1)
            {
                refc++;
                //This actually is because of a bug in KRN 0.6.0!
                int l=strrchr(refs.dptr,'>')-refs.dptr+1;
                strncpy(tmpstr,refs.dptr,l);
                art.Ref=tmpstr;
            }
            else
                art.Ref=emptystr;
            score=gdbm_fetch(scoredb,realkey);
            if (score.dptr)
            {
                scorec++;
            }
            art.save(false);
            nextkey = gdbm_nextkey ( artdb, key );
            free (key.dptr);
            key = nextkey;
        }

        printf ("Converting the newsgroup contents lists.\n");
        strcpy(path,getenv("HOME"));
        strcat (path,"/.kde/share/apps/krn/groupinfo");
        DIR *groupinfodir=opendir(path);
        if (!groupinfodir)
        {
            printf ("It looks like you have no groupinfo? Continuing anyway\n");
        }
        else
        {
            dbCursor <Article> cursor (dbCursorForUpdate);
            dirent *entry;
            while ((entry=readdir(groupinfodir)))
            {
                //name should iterate over the names of all newsgroups
                int nlen=strlen(entry->d_name);
                char *name=new char[nlen+1];
                strcpy (name,entry->d_name);

                if (!((nlen>5) && (!strncmp(".conf",name+nlen-5,5))))
                {
                    //Let's just ignore strange files
                    continue;
                }
                else
                    name[nlen-5]=0;

                if (name[0]=='.')
                    continue;
                strcpy(path,getenv("HOME"));
                strcat (path,"/.kde/share/apps/krn/");
                strcat (path,name);

                struct stat *buf=new struct stat;
                stat (path,buf);

                printf ("Group %s at %s\n",name,path);
                printf ("Size: %ld\n",buf->st_size);

                printf ("Getting or creating reference to group\n");
                dbReference <class group> groupRef;
                dbCursor <class group> groupCursor (dbCursorForUpdate);
                dbQuery q1;
                q1="name = ",name;
                if (groupCursor.select(q1)) //This group does exist
                {
                    printf ("Using existent reference\n");
                    groupRef=groupCursor.currentId();
                }
                else
                {
                    printf ("Inserting and using reference to new entry\n");
                    class group groupitem;
                    groupitem.name=name;
                    groupRef=insert (groupitem);
                }



                printf ("Adding connections between articles and group\n");

                int fd=open(path,O_RDONLY);
                char *buffer= new char[buf->st_size+1];
                buffer[buf->st_size]=0;
                read (fd,buffer,buf->st_size);
                close(fd);
                char *tok= strtok (buffer,"\n");
                while (tok)
                {
                    //Add the reference to the article with ID==tok
                    dbQuery q;
                    q="ID =",tok;
                    if (cursor.select(q))
                    {
                        cursor->groups.append(groupRef);
                        cursor.update();
                    }
                    tok=strtok(NULL,"\n");
                }

                delete [] buffer;
                printf ("Done with %s\n",name);
                printf ("Committing the Gigabase\n");
                db.commit();

            }
        }

        printf ("\nTotal %d articles. %d read, %d unread, %d Ref'd, %d scored, %d expires, %d marked.\n",
                counter,readc,unreadc,refc,scorec,expirec,ismarkedc);


        throw(0);
    }
    catch (int n)
    {
        if (refsdb)
        {
            printf ("Closing refs.db\n");
            gdbm_close(refsdb);
        }
        if (artdb)
        {
            printf ("Closing artinfo.db\n");
            gdbm_close(artdb);
        }
        if (scoredb)
        {
            printf ("Closing scores.db\n");
            gdbm_close(scoredb);
        }
        printf ("Closing Gigabase\n");
        db.close();

        printf ("Press enter.\n");
        getchar ();
        strictdelete=false;
        exit (n);
    }
}
