#ifndef ARTICLE_ITEM_H
#define ARTICLE_ITEM_H

#include <qlistview.h>

class Article;

class ArticleItem : public QListViewItem
{
public:
    ArticleItem (QListView *list,Article *art);
    ArticleItem (QListViewItem *parent,Article *art);
    void update(Article *art,bool triggered=false);
    void update();
    void insertItem ( QListViewItem * newChild );
    void removeItem ( QListViewItem * newChild );
    virtual const char *key ( int column, bool ascending ) const;
    int width(const QFontMetrics & fm, const QListView * lv, int c ) const;
    QString ID;
};

class ThreadItem : public ArticleItem
{
public:
    ThreadItem (QListView *list,const char *subject);
    void update(Article *art,bool triggered=false) {};
    void update() {};
    void insertItem ( QListViewItem * newChild );
    void removeItem ( QListViewItem * newChild );
    virtual const char *key ( int column, bool ascending ) const;
    QString Subject;
};

#endif