// KPPPLoad - a PPP load monitor
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <asm/types.h>
#include <linux/ppp_defs.h>

#include "PPPStats.h"
#include "Options.h"

#include "PPPStats.moc"

typedef struct
{
    struct ppp_stats  stats;
} DclPPPInfo;

PPPStats::PPPStats()
        : _rxTotal( 0 ),
          _txTotal( 0 ),
          _isUp( FALSE ),
          _retryId( -1 ),
          _periodicId( -1 ),
          _retries( 0 )
{
    if ((_s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
        perror("couldn't create IP socket");
        exit(1);
    }

    timerEvent( 0 );
    
    startTimer( options->getStatsInterval() * 1000 );
    if ( options->getPeriodicInterval() ) {
        _periodicId = startTimer( options->getPeriodicInterval() * 1000 );
    }

    if ( options->getPPPCommand() ) {
        _retryId = startTimer( options->getRetryInterval() * 1000 );
    }
}

void PPPStats::timerEvent( QTimerEvent* e )
{
    if ( ( !e ) || ( e->timerId() == _retryId ) )
    {
        _retries++;
        emit retryCount( _retries );
        system( options->getPPPCommand() );
    } else if ( ( e->timerId() == _periodicId ) && ( _isUp ) ) {
        system( options->getPeriodicCommand() );
    }
    
    DclPPPInfo        PPPInfo[1];
    struct ifreq      ifreq;
    struct ppp_stats* PPPStat;
    struct ppp_stats  LastPPPStat[1];
	
    memset (& ifreq, 0, sizeof (ifreq));
    sprintf ( ifreq.ifr_ifrn.ifrn_name, "ppp%d", options->getLinkNumber() );
	
    ifreq.ifr_ifru.ifru_data = (caddr_t) PPPInfo;
    PPPStat = & PPPInfo->stats;
    memset (LastPPPStat, 0, sizeof (LastPPPStat));
	
    if ( (ioctl (_s, SIOCDEVPRIVATE, (caddr_t) & ifreq) < 0) || ( !PPPStat->p.ppp_ibytes ) ) {
        if ( _isUp ) {
            _isUp = FALSE;
            _retries = 0;
            emit linkDown();
            if ( options->getPPPCommand() ) {
                _retryId = startTimer( options->getRetryInterval() * 1000 );
                system( options->getPPPCommand() );
            }
        }
        PPPStat->p.ppp_ibytes = 0;
        PPPStat->p.ppp_obytes = 0;
    } else if ( !_isUp ) {
        _isUp = TRUE;
        _retries = 0;
        emit linkUp();
        killTimer( _retryId );
        _retryId = -1;
    }

    unsigned int rxDelta = PPPStat->p.ppp_ibytes - _rxTotal;
    unsigned int txDelta = PPPStat->p.ppp_obytes - _txTotal;
    _rxTotal = PPPStat->p.ppp_ibytes;
    _txTotal = PPPStat->p.ppp_obytes;
    if ( rxDelta == _rxTotal ) rxDelta = 0;
    if ( txDelta == _txTotal ) txDelta = 0;
    emit changeStats( rxDelta, txDelta, _rxTotal, _txTotal );
}
