/***************************************************************************
                     knpostingmanager.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNPOSTINGMANAGER_H
#define KNPOSTINGMANAGER_H
#include <qobject.h>
#include <qlistview.h>
#include <qstring.h>
#include "knntpclient.h"
#include "knpostheader.h"
#include "knpostheaderlist.h"
#include "knfoldermanager.h"


class KNPostingManager : public QObject {
	
	Q_OBJECT

	public:
		KNPostingManager(QListView *v, KNFolderManager *fm);
		~KNPostingManager();
		void readConfig();
	
		bool showHdrs();
				
		bool setCurrent(KNHeaderBase *hdr);
		KNPostHeader* current()	{ return c_urrent; }
		
		void newMsg();
		void replyMsg(KNPostHeader::SendMode sMode);
		void mailTo(const char* email);
		
		void editCurrent();
		void deleteMsg(KNPostHeader *hdr=0);
		void removeMsg(KNPostHeader *hdr=0);
		void openInComposer(KNPostHeader *h);
		
		void sendMsg(KNPostHeader *hdr=0, bool now=true);
		void sendAllInOutbox();
    		
	
	public slots:			
		void slotMailTo(const char* email);	
		
		
	protected:
		void saveToFile(KNPostHeader *hdr);
		bool loadOView(KNPostHeader *hdr);
		bool loadBody(KNPostHeader *hdr);
		
		KNPostHeader* newHdr();
			
		KNFolderManager *fManager;
		QListView *view;
					
		QString  ownEmail ,ownName, replyTo, orga, quotSign, intro;
		KNPostHeader *c_urrent;
		bool incSig;
		
		QList<KNMessageComp> *compList;
		
		
	protected slots:
		void slotComposerDone(KNMessageComp*);
		void slotMsgSent(KNPostHeader *hdr, bool success);
				
		
		
		
			
};

#endif



























































































