/***************************************************************************
                     knlvitembase.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knlvitembase.h"
#include <qpixmap.h>
#include <kapp.h>


KNLVItemBase::KNLVItemBase(QListViewItem *item) : QListViewItem(item)
{
	mFirstColBold=false;
	mGreyOut=false;
}



KNLVItemBase::KNLVItemBase(QListView *view) : QListViewItem(view)
{
	mFirstColBold=false;
	mGreyOut=false;
}



KNLVItemBase::~KNLVItemBase()
{
}



void KNLVItemBase::paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int alignment)
{
	int xText=0, yText=0, xPM=0, yPM=0;
  QColor base;
	
	if(isSelected()) {
		QPen pen=p->pen();
		pen.setColor(kapp->selectTextColor);
		p->setPen(pen);
		base=kapp->selectColor;
	}
	else {
		if(mGreyOut) {
			QPen pen=p->pen();
			pen.setColor(cg.dark());
			p->setPen(pen);
		}
		base=cg.base();
	}
			
	p->fillRect(0,0,width, height(), QBrush(base));
	
	if(column==0) {
		
	  if(mFirstColBold) {
			QFont font=p->font();
			font.setBold(true);	
	  	p->setFont(font);
		}
	
		const QPixmap *pm;
		
		for(int i=0; i<3; i++) {
			 pm=pixmap(i);
			 if(pm) {
			 	yPM = (height() - pm->height())/2;	
				p->drawPixmap(xPM, yPM, *pm);
	 	  	xPM+=pm->width()+3;
	 	  }
		}
				
	 	xText=xPM;
	 	
	}
	
	yText=p->fontMetrics().ascent() + p->fontMetrics().leading()/2;
	p->drawText(xText, 0, width-xText-5, height(), alignment,	text(column));
}



int KNLVItemBase::width(const QFontMetrics &fm, const QListView *lv, int column)
{
	int ret = fm.boundingRect( text(column) ).width();
	
	if(column==0) {
		
		int i=0;
		const QPixmap *pm=pixmap(i);
		while(pm) {
			ret+=pixmap(i)->width()+3;
			i++;
		}
	}
	
	return ret;
}









