/***************************************************************************
                     kngroupselectdialog.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNGROUPSELECTDIALOG_H
#define KNGROUPSELECTDIALOG_H

#include <qdialog.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include "kngrouplistwidget.h"

class KNGroupSelectDialog : public QDialog  {
	
	Q_OBJECT

	public:
		KNGroupSelectDialog(QWidget *parent=0, const char *name=0, QStrList *groups=0);
		~KNGroupSelectDialog();
		
		void applyResult();
		
	protected:
		
	  void addToSelected(const char *text);
	  	  	
		QPushButton *ok, *cancel, *help, *add, *del;
		QListBox *lb;
		KNGroupListWidget *glw;
		QStrList *selGroups;
	
	protected slots:
		
		void slotAddBtn();				
		void slotRemoveBtn();			
																				
		void slotAdd(const char *text);
		void slotRemove(int i);
		
};

#endif















