/* ------------------------------------------------------------- 

    knglistbox.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: knglistbox.cpp,v 1.6 1999/05/19 20:45:04 ctuztas Exp $

   ------------------------------------------------------------- */

#include <knglistbox.h>

KNGListBox:: KNGListBox( QWidget *parent = 0,const char *name=0,int columns = 1, WFlags f = 0 )
  : KTabListBox( parent,name,columns,f )
{
  setSeparator('|');
  enableKey();

  // Pixmaps

  dict().insert( "R", new QPixmap( kapp->getIconLoader()->loadIcon( "red.xpm" )));
  dict().insert( "G", new QPixmap( kapp->getIconLoader()->loadIcon( "green.xpm" )));
  dict().insert( "Y", new QPixmap( kapp->getIconLoader()->loadIcon( "yellow.xpm" ))); 
  
  // KConfig
  config = kapp->getConfig();

};

void KNGListBox::writeConfig()
{
  QStrList strlst;

  KTabListBox::writeConfig();

  // Newgroups entry
  
  for ( int i = 0; i < numRows(); i++)
    strlst.append(text(i,0)); 

  config->writeEntry("newsgroups",strlst);
  Connect->writeConfig();
}

void KNGListBox::readConfig()
{
  QStrList strlst;
  QString str;

  KTabListBox::readConfig();

  config->readListEntry("newsgroups", strlst );

  for ( str = strlst.first(); str != 0; str = strlst.next() )
    {
      const char *tmp = Connect->initGroup( str );
      insertItem( tmp );
      // free ( tmp );
      delete tmp;
    }
}

